/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.bots;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.methods.send.SendAudio;
import org.telegram.telegrambots.api.methods.send.SendDocument;
import org.telegram.telegrambots.api.methods.send.SendPhoto;
import org.telegram.telegrambots.api.methods.send.SendSticker;
import org.telegram.telegrambots.api.methods.send.SendVideo;
import org.telegram.telegrambots.api.methods.send.SendVoice;
import org.telegram.telegrambots.api.objects.File;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.bots.AbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.exceptions.TelegramApiException;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.updateshandlers.DownloadFileCallback;
import org.telegram.telegrambots.updateshandlers.SentCallback;

public abstract class DefaultAbsSender
extends AbsSender {
    private static final ContentType TEXT_PLAIN_CONTENT_TYPE = ContentType.create("text/plain", StandardCharsets.UTF_8);
    private final ExecutorService exe;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final DefaultBotOptions options;
    private volatile CloseableHttpClient httpclient;
    private volatile RequestConfig requestConfig;

    protected DefaultAbsSender(DefaultBotOptions options) {
        this.exe = Executors.newFixedThreadPool(options.getMaxThreads());
        this.options = options;
        this.httpclient = HttpClientBuilder.create().setSSLHostnameVerifier(new NoopHostnameVerifier()).setConnectionTimeToLive(70L, TimeUnit.SECONDS).setMaxConnTotal(100).build();
        this.requestConfig = options.getRequestConfig();
    }

    public abstract String getBotToken();

    public final DefaultBotOptions getOptions() {
        return this.options;
    }

    public final java.io.File downloadFile(String filePath) throws TelegramApiException {
        java.io.File output;
        if (filePath == null || filePath.isEmpty()) {
            throw new TelegramApiException("Parameter file can not be null");
        }
        String url = File.getFileUrl(this.getBotToken(), filePath);
        try {
            output = java.io.File.createTempFile(Long.toString(System.currentTimeMillis()), ".tmp");
            FileUtils.copyURLToFile(new URL(url), output);
        }
        catch (MalformedURLException e) {
            throw new TelegramApiException("Wrong url for file: " + url);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Error downloading the file", e);
        }
        return output;
    }

    public final java.io.File downloadFile(File file) throws TelegramApiException {
        java.io.File output;
        if (file == null) {
            throw new TelegramApiException("Parameter file can not be null");
        }
        String url = file.getFileUrl(this.getBotToken());
        try {
            output = java.io.File.createTempFile(file.getFileId(), ".tmp");
            FileUtils.copyURLToFile(new URL(url), output);
        }
        catch (MalformedURLException e) {
            throw new TelegramApiException("Wrong url for file: " + url);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Error downloading the file", e);
        }
        return output;
    }

    public final void downloadFileAsync(final String filePath, final DownloadFileCallback<String> callback) throws TelegramApiException {
        if (filePath == null || filePath.isEmpty()) {
            throw new TelegramApiException("Parameter filePath can not be null");
        }
        if (callback == null) {
            throw new TelegramApiException("Parameter callback can not be null");
        }
        this.exe.submit(new Runnable(){

            @Override
            public void run() {
                String url = File.getFileUrl(DefaultAbsSender.this.getBotToken(), filePath);
                try {
                    java.io.File output = java.io.File.createTempFile(Long.toString(System.currentTimeMillis()), ".tmp");
                    FileUtils.copyURLToFile(new URL(url), output);
                    callback.onResult(filePath, output);
                }
                catch (MalformedURLException e) {
                    callback.onException(filePath, new TelegramApiException("Wrong url for file: " + url));
                }
                catch (IOException e) {
                    callback.onException(filePath, new TelegramApiRequestException("Error downloading the file", e));
                }
            }
        });
    }

    public final void downloadFileAsync(final File file, final DownloadFileCallback<File> callback) throws TelegramApiException {
        if (file == null) {
            throw new TelegramApiException("Parameter file can not be null");
        }
        if (callback == null) {
            throw new TelegramApiException("Parameter callback can not be null");
        }
        this.exe.submit(new Runnable(){

            @Override
            public void run() {
                String url = file.getFileUrl(DefaultAbsSender.this.getBotToken());
                try {
                    java.io.File output = java.io.File.createTempFile(file.getFileId(), ".tmp");
                    FileUtils.copyURLToFile(new URL(url), output);
                    callback.onResult(file, output);
                }
                catch (MalformedURLException e) {
                    callback.onException(file, new TelegramApiException("Wrong url for file: " + url));
                }
                catch (IOException e) {
                    callback.onException(file, new TelegramApiRequestException("Error downloading the file", e));
                }
            }
        });
    }

    @Override
    public final Message sendDocument(SendDocument sendDocument) throws TelegramApiException {
        String responseContent;
        if (sendDocument == null) {
            throw new TelegramApiException("Parameter sendDocument can not be null");
        }
        sendDocument.validate();
        try {
            String url = this.getBaseUrl() + "senddocument";
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(this.requestConfig);
            if (sendDocument.isNewDocument()) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addTextBody("chat_id", sendDocument.getChatId());
                if (sendDocument.getNewDocumentFile() != null) {
                    builder.addBinaryBody("document", sendDocument.getNewDocumentFile());
                } else if (sendDocument.getNewDocumentStream() != null) {
                    builder.addBinaryBody("document", sendDocument.getNewDocumentStream(), ContentType.APPLICATION_OCTET_STREAM, sendDocument.getDocumentName());
                } else {
                    builder.addBinaryBody("document", new java.io.File(sendDocument.getDocument()), ContentType.APPLICATION_OCTET_STREAM, sendDocument.getDocumentName());
                }
                if (sendDocument.getReplyMarkup() != null) {
                    builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendDocument.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
                }
                if (sendDocument.getReplyToMessageId() != null) {
                    builder.addTextBody("reply_to_message_id", sendDocument.getReplyToMessageId().toString());
                }
                if (sendDocument.getCaption() != null) {
                    builder.addTextBody("caption", sendDocument.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
                }
                if (sendDocument.getDisableNotification() != null) {
                    builder.addTextBody("disable_notification", sendDocument.getDisableNotification().toString());
                }
                HttpEntity multipart = builder.build();
                httppost.setEntity(multipart);
            } else {
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                nameValuePairs.add(new BasicNameValuePair("chat_id", sendDocument.getChatId()));
                nameValuePairs.add(new BasicNameValuePair("document", sendDocument.getDocument()));
                if (sendDocument.getReplyMarkup() != null) {
                    nameValuePairs.add(new BasicNameValuePair("reply_markup", this.objectMapper.writeValueAsString(sendDocument.getReplyMarkup())));
                }
                if (sendDocument.getReplyToMessageId() != null) {
                    nameValuePairs.add(new BasicNameValuePair("reply_to_message_id", sendDocument.getReplyToMessageId().toString()));
                }
                if (sendDocument.getCaption() != null) {
                    nameValuePairs.add(new BasicNameValuePair("caption", sendDocument.getCaption()));
                }
                if (sendDocument.getDisableNotification() != null) {
                    nameValuePairs.add(new BasicNameValuePair("disable_notification", sendDocument.getDisableNotification().toString()));
                }
                httppost.setEntity(new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8));
            }
            try (CloseableHttpResponse response = this.httpclient.execute(httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                responseContent = EntityUtils.toString((HttpEntity)buf, StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send document", e);
        }
        return sendDocument.deserializeResponse(responseContent);
    }

    @Override
    public final Message sendPhoto(SendPhoto sendPhoto) throws TelegramApiException {
        String responseContent;
        if (sendPhoto == null) {
            throw new TelegramApiException("Parameter sendPhoto can not be null");
        }
        sendPhoto.validate();
        try {
            String url = this.getBaseUrl() + "sendphoto";
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(this.requestConfig);
            if (sendPhoto.isNewPhoto()) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addTextBody("chat_id", sendPhoto.getChatId());
                if (sendPhoto.getNewPhotoFile() != null) {
                    builder.addBinaryBody("photo", sendPhoto.getNewPhotoFile());
                } else if (sendPhoto.getNewPhotoStream() != null) {
                    builder.addBinaryBody("photo", sendPhoto.getNewPhotoStream(), ContentType.APPLICATION_OCTET_STREAM, sendPhoto.getPhotoName());
                } else {
                    builder.addBinaryBody("photo", new java.io.File(sendPhoto.getPhoto()), ContentType.APPLICATION_OCTET_STREAM, sendPhoto.getPhotoName());
                }
                if (sendPhoto.getReplyMarkup() != null) {
                    builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendPhoto.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
                }
                if (sendPhoto.getReplyToMessageId() != null) {
                    builder.addTextBody("reply_to_message_id", sendPhoto.getReplyToMessageId().toString());
                }
                if (sendPhoto.getCaption() != null) {
                    builder.addTextBody("caption", sendPhoto.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
                }
                if (sendPhoto.getDisableNotification() != null) {
                    builder.addTextBody("disable_notification", sendPhoto.getDisableNotification().toString());
                }
                HttpEntity multipart = builder.build();
                httppost.setEntity(multipart);
            } else {
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                nameValuePairs.add(new BasicNameValuePair("chat_id", sendPhoto.getChatId()));
                nameValuePairs.add(new BasicNameValuePair("photo", sendPhoto.getPhoto()));
                if (sendPhoto.getReplyMarkup() != null) {
                    nameValuePairs.add(new BasicNameValuePair("reply_markup", this.objectMapper.writeValueAsString(sendPhoto.getReplyMarkup())));
                }
                if (sendPhoto.getReplyToMessageId() != null) {
                    nameValuePairs.add(new BasicNameValuePair("reply_to_message_id", sendPhoto.getReplyToMessageId().toString()));
                }
                if (sendPhoto.getCaption() != null) {
                    nameValuePairs.add(new BasicNameValuePair("caption", sendPhoto.getCaption()));
                }
                if (sendPhoto.getDisableNotification() != null) {
                    nameValuePairs.add(new BasicNameValuePair("disable_notification", sendPhoto.getDisableNotification().toString()));
                }
                httppost.setEntity(new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8));
            }
            try (CloseableHttpResponse response = this.httpclient.execute(httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                responseContent = EntityUtils.toString((HttpEntity)buf, StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send photo", e);
        }
        return sendPhoto.deserializeResponse(responseContent);
    }

    @Override
    public final Message sendVideo(SendVideo sendVideo) throws TelegramApiException {
        String responseContent;
        if (sendVideo == null) {
            throw new TelegramApiException("Parameter sendVideo can not be null");
        }
        sendVideo.validate();
        try {
            String url = this.getBaseUrl() + "sendvideo";
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(this.requestConfig);
            if (sendVideo.isNewVideo()) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addTextBody("chat_id", sendVideo.getChatId());
                if (sendVideo.getNewVideoFile() != null) {
                    builder.addBinaryBody("video", sendVideo.getNewVideoFile());
                } else if (sendVideo.getNewVideoStream() != null) {
                    builder.addBinaryBody("video", sendVideo.getNewVideoStream(), ContentType.APPLICATION_OCTET_STREAM, sendVideo.getVideoName());
                } else {
                    builder.addBinaryBody("video", new java.io.File(sendVideo.getVideo()), ContentType.APPLICATION_OCTET_STREAM, sendVideo.getVideoName());
                }
                if (sendVideo.getReplyMarkup() != null) {
                    builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendVideo.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
                }
                if (sendVideo.getReplyToMessageId() != null) {
                    builder.addTextBody("reply_to_message_id", sendVideo.getReplyToMessageId().toString());
                }
                if (sendVideo.getCaption() != null) {
                    builder.addTextBody("caption", sendVideo.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
                }
                if (sendVideo.getDuration() != null) {
                    builder.addTextBody("duration", sendVideo.getDuration().toString());
                }
                if (sendVideo.getWidth() != null) {
                    builder.addTextBody("width", sendVideo.getWidth().toString());
                }
                if (sendVideo.getHeight() != null) {
                    builder.addTextBody("height", sendVideo.getHeight().toString());
                }
                if (sendVideo.getDisableNotification() != null) {
                    builder.addTextBody("disable_notification", sendVideo.getDisableNotification().toString());
                }
                HttpEntity multipart = builder.build();
                httppost.setEntity(multipart);
            } else {
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                nameValuePairs.add(new BasicNameValuePair("chat_id", sendVideo.getChatId()));
                nameValuePairs.add(new BasicNameValuePair("video", sendVideo.getVideo()));
                if (sendVideo.getReplyMarkup() != null) {
                    nameValuePairs.add(new BasicNameValuePair("reply_markup", this.objectMapper.writeValueAsString(sendVideo.getReplyMarkup())));
                }
                if (sendVideo.getReplyToMessageId() != null) {
                    nameValuePairs.add(new BasicNameValuePair("reply_to_message_id", sendVideo.getReplyToMessageId().toString()));
                }
                if (sendVideo.getCaption() != null) {
                    nameValuePairs.add(new BasicNameValuePair("caption", sendVideo.getCaption()));
                }
                if (sendVideo.getDuration() != null) {
                    nameValuePairs.add(new BasicNameValuePair("duration", sendVideo.getDuration().toString()));
                }
                if (sendVideo.getWidth() != null) {
                    nameValuePairs.add(new BasicNameValuePair("width", sendVideo.getWidth().toString()));
                }
                if (sendVideo.getHeight() != null) {
                    nameValuePairs.add(new BasicNameValuePair("height", sendVideo.getHeight().toString()));
                }
                if (sendVideo.getDisableNotification() != null) {
                    nameValuePairs.add(new BasicNameValuePair("disable_notification", sendVideo.getDisableNotification().toString()));
                }
                httppost.setEntity(new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8));
            }
            try (CloseableHttpResponse response = this.httpclient.execute(httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                responseContent = EntityUtils.toString((HttpEntity)buf, StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send video", e);
        }
        return sendVideo.deserializeResponse(responseContent);
    }

    @Override
    public final Message sendSticker(SendSticker sendSticker) throws TelegramApiException {
        String responseContent;
        if (sendSticker == null) {
            throw new TelegramApiException("Parameter sendSticker can not be null");
        }
        sendSticker.validate();
        try {
            String url = this.getBaseUrl() + "sendsticker";
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(this.requestConfig);
            if (sendSticker.isNewSticker()) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addTextBody("chat_id", sendSticker.getChatId());
                if (sendSticker.getNewStickerFile() != null) {
                    builder.addBinaryBody("sticker", sendSticker.getNewStickerFile());
                } else if (sendSticker.getNewStickerStream() != null) {
                    builder.addBinaryBody("sticker", sendSticker.getNewStickerStream(), ContentType.APPLICATION_OCTET_STREAM, sendSticker.getStickerName());
                } else {
                    builder.addBinaryBody("sticker", new java.io.File(sendSticker.getSticker()), ContentType.APPLICATION_OCTET_STREAM, sendSticker.getStickerName());
                }
                if (sendSticker.getReplyMarkup() != null) {
                    builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendSticker.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
                }
                if (sendSticker.getReplyToMessageId() != null) {
                    builder.addTextBody("reply_to_message_id", sendSticker.getReplyToMessageId().toString());
                }
                if (sendSticker.getDisableNotification() != null) {
                    builder.addTextBody("disable_notification", sendSticker.getDisableNotification().toString());
                }
                HttpEntity multipart = builder.build();
                httppost.setEntity(multipart);
            } else {
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                nameValuePairs.add(new BasicNameValuePair("chat_id", sendSticker.getChatId()));
                nameValuePairs.add(new BasicNameValuePair("sticker", sendSticker.getSticker()));
                if (sendSticker.getReplyMarkup() != null) {
                    nameValuePairs.add(new BasicNameValuePair("reply_markup", this.objectMapper.writeValueAsString(sendSticker.getReplyMarkup())));
                }
                if (sendSticker.getReplyToMessageId() != null) {
                    nameValuePairs.add(new BasicNameValuePair("reply_to_message_id", sendSticker.getReplyToMessageId().toString()));
                }
                if (sendSticker.getDisableNotification() != null) {
                    nameValuePairs.add(new BasicNameValuePair("disable_notification", sendSticker.getDisableNotification().toString()));
                }
                httppost.setEntity(new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8));
            }
            try (CloseableHttpResponse response = this.httpclient.execute(httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                responseContent = EntityUtils.toString((HttpEntity)buf, StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send sticker", e);
        }
        return sendSticker.deserializeResponse(responseContent);
    }

    @Override
    public final Message sendAudio(SendAudio sendAudio) throws TelegramApiException {
        String responseContent;
        if (sendAudio == null) {
            throw new TelegramApiException("Parameter sendAudio can not be null");
        }
        sendAudio.validate();
        try {
            String url = this.getBaseUrl() + "sendaudio";
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(this.requestConfig);
            if (sendAudio.isNewAudio()) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addTextBody("chat_id", sendAudio.getChatId());
                if (sendAudio.getNewAudioFile() != null) {
                    builder.addBinaryBody("audio", sendAudio.getNewAudioFile());
                } else if (sendAudio.getNewAudioStream() != null) {
                    builder.addBinaryBody("audio", sendAudio.getNewAudioStream(), ContentType.APPLICATION_OCTET_STREAM, sendAudio.getAudioName());
                } else {
                    builder.addBinaryBody("audio", new java.io.File(sendAudio.getAudio()), ContentType.create("audio/mpeg"), sendAudio.getAudioName());
                }
                if (sendAudio.getReplyMarkup() != null) {
                    builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendAudio.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
                }
                if (sendAudio.getReplyToMessageId() != null) {
                    builder.addTextBody("reply_to_message_id", sendAudio.getReplyToMessageId().toString());
                }
                if (sendAudio.getPerformer() != null) {
                    builder.addTextBody("performer", sendAudio.getPerformer());
                }
                if (sendAudio.getTitle() != null) {
                    builder.addTextBody("title", sendAudio.getTitle());
                }
                if (sendAudio.getDuration() != null) {
                    builder.addTextBody("duration", sendAudio.getDuration().toString());
                }
                if (sendAudio.getDisableNotification() != null) {
                    builder.addTextBody("disable_notification", sendAudio.getDisableNotification().toString());
                }
                if (sendAudio.getCaption() != null) {
                    builder.addTextBody("caption", sendAudio.getCaption());
                }
                HttpEntity multipart = builder.build();
                httppost.setEntity(multipart);
            } else {
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                nameValuePairs.add(new BasicNameValuePair("chat_id", sendAudio.getChatId()));
                nameValuePairs.add(new BasicNameValuePair("audio", sendAudio.getAudio()));
                if (sendAudio.getReplyMarkup() != null) {
                    nameValuePairs.add(new BasicNameValuePair("reply_markup", this.objectMapper.writeValueAsString(sendAudio.getReplyMarkup())));
                }
                if (sendAudio.getReplyToMessageId() != null) {
                    nameValuePairs.add(new BasicNameValuePair("reply_to_message_id", sendAudio.getReplyToMessageId().toString()));
                }
                if (sendAudio.getPerformer() != null) {
                    nameValuePairs.add(new BasicNameValuePair("performer", sendAudio.getPerformer()));
                }
                if (sendAudio.getTitle() != null) {
                    nameValuePairs.add(new BasicNameValuePair("title", sendAudio.getTitle()));
                }
                if (sendAudio.getDisableNotification() != null) {
                    nameValuePairs.add(new BasicNameValuePair("disable_notification", sendAudio.getDisableNotification().toString()));
                }
                if (sendAudio.getCaption() != null) {
                    nameValuePairs.add(new BasicNameValuePair("caption", sendAudio.getCaption()));
                }
                httppost.setEntity(new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8));
            }
            try (CloseableHttpResponse response = this.httpclient.execute(httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                responseContent = EntityUtils.toString((HttpEntity)buf, StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send sticker", e);
        }
        return sendAudio.deserializeResponse(responseContent);
    }

    @Override
    public final Message sendVoice(SendVoice sendVoice) throws TelegramApiException {
        String responseContent;
        if (sendVoice == null) {
            throw new TelegramApiException("Parameter sendVoice can not be null");
        }
        sendVoice.validate();
        try {
            String url = this.getBaseUrl() + "sendvoice";
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(this.requestConfig);
            if (sendVoice.isNewVoice()) {
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addTextBody("chat_id", sendVoice.getChatId());
                if (sendVoice.getNewVoiceFile() != null) {
                    builder.addBinaryBody("voice", sendVoice.getNewVoiceFile());
                } else if (sendVoice.getNewVoiceStream() != null) {
                    builder.addBinaryBody("voice", sendVoice.getNewVoiceStream(), ContentType.APPLICATION_OCTET_STREAM, sendVoice.getVoiceName());
                } else {
                    builder.addBinaryBody("voice", new java.io.File(sendVoice.getVoice()), ContentType.create("audio/ogg"), sendVoice.getVoiceName());
                }
                if (sendVoice.getReplyMarkup() != null) {
                    builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendVoice.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
                }
                if (sendVoice.getReplyToMessageId() != null) {
                    builder.addTextBody("reply_to_message_id", sendVoice.getReplyToMessageId().toString());
                }
                if (sendVoice.getDisableNotification() != null) {
                    builder.addTextBody("disable_notification", sendVoice.getDisableNotification().toString());
                }
                if (sendVoice.getDuration() != null) {
                    builder.addTextBody("duration", sendVoice.getDuration().toString());
                }
                if (sendVoice.getCaption() != null) {
                    builder.addTextBody("caption", sendVoice.getCaption());
                }
                HttpEntity multipart = builder.build();
                httppost.setEntity(multipart);
            } else {
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                nameValuePairs.add(new BasicNameValuePair("chat_id", sendVoice.getChatId()));
                nameValuePairs.add(new BasicNameValuePair("voice", sendVoice.getVoice()));
                if (sendVoice.getReplyMarkup() != null) {
                    nameValuePairs.add(new BasicNameValuePair("reply_markup", this.objectMapper.writeValueAsString(sendVoice.getReplyMarkup())));
                }
                if (sendVoice.getReplyToMessageId() != null) {
                    nameValuePairs.add(new BasicNameValuePair("reply_to_message_id", sendVoice.getReplyToMessageId().toString()));
                }
                if (sendVoice.getDisableNotification() != null) {
                    nameValuePairs.add(new BasicNameValuePair("disable_notification", sendVoice.getDisableNotification().toString()));
                }
                if (sendVoice.getDuration() != null) {
                    nameValuePairs.add(new BasicNameValuePair("duration", sendVoice.getDuration().toString()));
                }
                if (sendVoice.getCaption() != null) {
                    nameValuePairs.add(new BasicNameValuePair("caption", sendVoice.getCaption()));
                }
                httppost.setEntity(new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8));
            }
            try (CloseableHttpResponse response = this.httpclient.execute(httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                responseContent = EntityUtils.toString((HttpEntity)buf, StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send sticker", e);
        }
        return sendVoice.deserializeResponse(responseContent);
    }

    @Override
    protected final <T extends Serializable, Method extends BotApiMethod<T>, Callback extends SentCallback<T>> void sendApiMethodAsync(final Method method, final Callback callback) {
        this.exe.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    method.validate();
                    String url = DefaultAbsSender.this.getBaseUrl() + method.getMethod();
                    HttpPost httppost = new HttpPost(url);
                    httppost.setConfig(DefaultAbsSender.this.requestConfig);
                    httppost.addHeader("charset", StandardCharsets.UTF_8.name());
                    httppost.setEntity(new StringEntity(DefaultAbsSender.this.objectMapper.writeValueAsString(method), ContentType.APPLICATION_JSON));
                    try (CloseableHttpResponse response = DefaultAbsSender.this.httpclient.execute(httppost);){
                        HttpEntity ht = response.getEntity();
                        BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                        String responseContent = EntityUtils.toString((HttpEntity)buf, StandardCharsets.UTF_8);
                        try {
                            callback.onResult(method, method.deserializeResponse(responseContent));
                        }
                        catch (TelegramApiRequestException e) {
                            callback.onError(method, e);
                        }
                    }
                }
                catch (IOException | TelegramApiValidationException e) {
                    callback.onException(method, e);
                }
            }
        });
    }

    @Override
    protected final <T extends Serializable, Method extends BotApiMethod<T>> T sendApiMethod(Method method) throws TelegramApiException {
        String responseContent;
        method.validate();
        try {
            String url = this.getBaseUrl() + method.getMethod();
            HttpPost httppost = new HttpPost(url);
            httppost.setConfig(this.requestConfig);
            httppost.addHeader("charset", StandardCharsets.UTF_8.name());
            httppost.setEntity(new StringEntity(this.objectMapper.writeValueAsString(method), ContentType.APPLICATION_JSON));
            try (CloseableHttpResponse response = this.httpclient.execute(httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                responseContent = EntityUtils.toString((HttpEntity)buf, StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to execute " + method.getMethod() + " method", e);
        }
        return method.deserializeResponse(responseContent);
    }

    private String getBaseUrl() {
        return "https://api.telegram.org/bot" + this.getBotToken() + "/";
    }
}

