/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.ChatMember;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class GetChatAdministrators
extends BotApiMethod<ArrayList<ChatMember>> {
    public static final String PATH = "getChatAdministrators";
    private static final String CHATID_FIELD = "chat_id";
    @JsonProperty(value="chat_id")
    private String chatId;

    public String getChatId() {
        return this.chatId;
    }

    public GetChatAdministrators setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public GetChatAdministrators setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ArrayList<ChatMember> deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<ArrayList<ChatMember>>>(){});
            if (result.getOk().booleanValue()) {
                return (ArrayList)result.getResult();
            }
            throw new TelegramApiRequestException("Error getting chat administrators", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId can't be null", this);
        }
    }

    public String toString() {
        return "GetChatAdministrators{chatId='" + this.chatId + '\'' + '}';
    }
}

