/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.api.methods.ActionType;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class SendChatAction
extends BotApiMethod<Boolean> {
    public static final String PATH = "sendChatAction";
    public static final String CHATID_FIELD = "chat_id";
    public static final String ACTION_FIELD = "action";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="action")
    private String action;

    public String getChatId() {
        return this.chatId;
    }

    @JsonIgnore
    public ActionType getAction() {
        return ActionType.get(this.action);
    }

    public SendChatAction setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SendChatAction setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    @JsonIgnore
    public SendChatAction setAction(ActionType action) {
        this.action = action.toString();
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending chat action", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.action == null) {
            throw new TelegramApiValidationException("Action parameter can't be empty", this);
        }
    }

    public String toString() {
        return "SendChatAction{chatId='" + this.chatId + '\'' + ", action='" + this.action + '\'' + '}';
    }
}

