/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.InvalidParameterException;
import java.text.MessageFormat;
import org.telegram.telegrambots.api.interfaces.BotApiObject;

public class File
implements BotApiObject {
    @JsonIgnore
    @Deprecated
    public static final String FILEBASEURL = "https://api.telegram.org/file/bot{0}/{1}";
    private static final String FILE_ID = "file_id";
    private static final String FILE_SIZE_FIELD = "file_size";
    private static final String FILE_PATH_FIELD = "file_path";
    @JsonProperty(value="file_id")
    private String fileId;
    @JsonProperty(value="file_size")
    private Integer fileSize;
    @JsonProperty(value="file_path")
    private String filePath;

    public String getFileId() {
        return this.fileId;
    }

    public Integer getFileSize() {
        return this.fileSize;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String toString() {
        return "File{fileId='" + this.fileId + '\'' + ", fileSize=" + this.fileSize + ", filePath='" + this.filePath + '\'' + '}';
    }

    public String getFileUrl(String botToken) {
        return File.getFileUrl(botToken, this.filePath);
    }

    public static String getFileUrl(String botToken, String filePath) {
        if (botToken == null || botToken.isEmpty()) {
            throw new InvalidParameterException("Bot token can't be empty");
        }
        return MessageFormat.format(FILEBASEURL, botToken, filePath);
    }
}

