/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.bots;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.telegram.telegrambots.ApiContext;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.Update;
import org.telegram.telegrambots.bots.AbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.bots.commands.BotCommand;
import org.telegram.telegrambots.bots.commands.CommandRegistry;
import org.telegram.telegrambots.bots.commands.ICommandRegistry;

public abstract class TelegramLongPollingCommandBot
extends TelegramLongPollingBot
implements ICommandRegistry {
    private final CommandRegistry commandRegistry;

    public TelegramLongPollingCommandBot() {
        this(ApiContext.getInstance(DefaultBotOptions.class));
    }

    public TelegramLongPollingCommandBot(DefaultBotOptions options) {
        this(options, true);
    }

    public TelegramLongPollingCommandBot(DefaultBotOptions options, boolean allowCommandsWithUsername) {
        super(options);
        this.commandRegistry = new CommandRegistry(allowCommandsWithUsername, this.getBotUsername());
    }

    @Override
    public final void onUpdateReceived(Update update) {
        Message message;
        if (update.hasMessage() && (message = update.getMessage()).isCommand() && !this.filter(message) && this.commandRegistry.executeCommand(this, message)) {
            return;
        }
        this.processNonCommandUpdate(update);
    }

    protected boolean filter(Message message) {
        return false;
    }

    @Override
    public final boolean register(BotCommand botCommand) {
        return this.commandRegistry.register(botCommand);
    }

    @Override
    public final Map<BotCommand, Boolean> registerAll(BotCommand ... botCommands) {
        return this.commandRegistry.registerAll(botCommands);
    }

    @Override
    public final boolean deregister(BotCommand botCommand) {
        return this.commandRegistry.deregister(botCommand);
    }

    @Override
    public final Map<BotCommand, Boolean> deregisterAll(BotCommand ... botCommands) {
        return this.commandRegistry.deregisterAll(botCommands);
    }

    @Override
    public final Collection<BotCommand> getRegisteredCommands() {
        return this.commandRegistry.getRegisteredCommands();
    }

    @Override
    public void registerDefaultAction(BiConsumer<AbsSender, Message> defaultConsumer) {
        this.commandRegistry.registerDefaultAction(defaultConsumer);
    }

    @Override
    public final BotCommand getRegisteredCommand(String commandIdentifier) {
        return this.commandRegistry.getRegisteredCommand(commandIdentifier);
    }

    public abstract void processNonCommandUpdate(Update var1);
}

