/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.bots;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.telegram.telegrambots.ApiContext;
import org.telegram.telegrambots.bots.DefaultAbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.generics.WebhookBot;

public abstract class TelegramWebhookBot
extends DefaultAbsSender
implements WebhookBot {
    private final DefaultBotOptions botOptions;

    public TelegramWebhookBot() {
        this((DefaultBotOptions)ApiContext.getInstance(DefaultBotOptions.class));
    }

    public TelegramWebhookBot(DefaultBotOptions options) {
        super(options);
        this.botOptions = options;
    }

    public void setWebhook(String url, String publicCertificatePath) throws TelegramApiRequestException {
        try (CloseableHttpClient httpclient = HttpClientBuilder.create().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();){
            File certificate;
            String requestUrl = this.getBaseUrl() + this.getBotToken() + "/" + "setwebhook";
            HttpPost httppost = new HttpPost(requestUrl);
            httppost.setConfig(this.botOptions.getRequestConfig());
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("url", url);
            if (this.botOptions.getMaxWebhookConnections() != null) {
                builder.addTextBody("max_connections", this.botOptions.getMaxWebhookConnections().toString());
            }
            if (this.botOptions.getAllowedUpdates() != null) {
                builder.addTextBody("allowed_updates", new JSONArray((Object)this.botOptions.getMaxWebhookConnections()).toString());
            }
            if (publicCertificatePath != null && (certificate = new File(publicCertificatePath)).exists()) {
                builder.addBinaryBody("certificate", certificate, ContentType.TEXT_PLAIN, certificate.getName());
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                String responseContent = EntityUtils.toString((HttpEntity)buf, (Charset)StandardCharsets.UTF_8);
                JSONObject jsonObject = new JSONObject(responseContent);
                if (!jsonObject.getBoolean("ok")) {
                    throw new TelegramApiRequestException("Error setting webhook", jsonObject);
                }
            }
        }
        catch (JSONException e) {
            throw new TelegramApiRequestException("Error deserializing setWebhook method response", (Throwable)e);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Error executing setWebook method", (Throwable)e);
        }
    }
}

