/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.bots;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.methods.groupadministration.SetChatPhoto;
import org.telegram.telegrambots.api.methods.send.SendAudio;
import org.telegram.telegrambots.api.methods.send.SendDocument;
import org.telegram.telegrambots.api.methods.send.SendPhoto;
import org.telegram.telegrambots.api.methods.send.SendSticker;
import org.telegram.telegrambots.api.methods.send.SendVideo;
import org.telegram.telegrambots.api.methods.send.SendVideoNote;
import org.telegram.telegrambots.api.methods.send.SendVoice;
import org.telegram.telegrambots.api.methods.stickers.AddStickerToSet;
import org.telegram.telegrambots.api.methods.stickers.CreateNewStickerSet;
import org.telegram.telegrambots.api.methods.stickers.UploadStickerFile;
import org.telegram.telegrambots.api.objects.File;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.bots.AbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.exceptions.TelegramApiException;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;
import org.telegram.telegrambots.updateshandlers.DownloadFileCallback;
import org.telegram.telegrambots.updateshandlers.SentCallback;

public abstract class DefaultAbsSender
extends AbsSender {
    private static final ContentType TEXT_PLAIN_CONTENT_TYPE = ContentType.create("text/plain", StandardCharsets.UTF_8);
    private final ExecutorService exe;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final DefaultBotOptions options;
    private volatile CloseableHttpClient httpclient;
    private volatile RequestConfig requestConfig;

    protected DefaultAbsSender(DefaultBotOptions options) {
        this.exe = Executors.newFixedThreadPool(options.getMaxThreads());
        this.options = options;
        this.httpclient = HttpClientBuilder.create().setSSLHostnameVerifier(new NoopHostnameVerifier()).setConnectionTimeToLive(70L, TimeUnit.SECONDS).setMaxConnTotal(100).build();
        this.requestConfig = options.getRequestConfig();
        if (this.requestConfig == null) {
            this.requestConfig = RequestConfig.copy(RequestConfig.custom().build()).setSocketTimeout(75000).setConnectTimeout(75000).setConnectionRequestTimeout(75000).build();
        }
    }

    public abstract String getBotToken();

    public final DefaultBotOptions getOptions() {
        return this.options;
    }

    public final java.io.File downloadFile(String filePath) throws TelegramApiException {
        if (filePath == null || filePath.isEmpty()) {
            throw new TelegramApiException("Parameter file can not be null");
        }
        String url = File.getFileUrl(this.getBotToken(), filePath);
        String tempFileName = Long.toString(System.currentTimeMillis());
        return this.downloadToTemporaryFileWrappingExceptions(url, tempFileName);
    }

    public final java.io.File downloadFile(File file) throws TelegramApiException {
        this.assertParamNotNull(file, "file");
        String url = file.getFileUrl(this.getBotToken());
        String tempFileName = file.getFileId();
        return this.downloadToTemporaryFileWrappingExceptions(url, tempFileName);
    }

    public final void downloadFileAsync(String filePath, DownloadFileCallback<String> callback) throws TelegramApiException {
        if (filePath == null || filePath.isEmpty()) {
            throw new TelegramApiException("Parameter filePath can not be null");
        }
        this.assertParamNotNull(callback, "callback");
        String url = File.getFileUrl(this.getBotToken(), filePath);
        String tempFileName = Long.toString(System.currentTimeMillis());
        this.exe.submit(this.getDownloadFileAsyncJob(filePath, callback, url, tempFileName));
    }

    public final void downloadFileAsync(File file, DownloadFileCallback<File> callback) throws TelegramApiException {
        this.assertParamNotNull(file, "file");
        this.assertParamNotNull(callback, "callback");
        String url = file.getFileUrl(this.getBotToken());
        String tempFileName = file.getFileId();
        this.exe.submit(this.getDownloadFileAsyncJob(file, callback, url, tempFileName));
    }

    @Override
    public final Message sendDocument(SendDocument sendDocument) throws TelegramApiException {
        this.assertParamNotNull(sendDocument, "sendDocument");
        sendDocument.validate();
        try {
            String url = this.getBaseUrl() + "senddocument";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("chat_id", sendDocument.getChatId(), TEXT_PLAIN_CONTENT_TYPE);
            if (sendDocument.isNewDocument()) {
                if (sendDocument.getNewDocumentFile() != null) {
                    builder.addBinaryBody("document", sendDocument.getNewDocumentFile());
                } else if (sendDocument.getNewDocumentStream() != null) {
                    builder.addBinaryBody("document", sendDocument.getNewDocumentStream(), ContentType.APPLICATION_OCTET_STREAM, sendDocument.getDocumentName());
                } else {
                    builder.addBinaryBody("document", new java.io.File(sendDocument.getDocument()), ContentType.APPLICATION_OCTET_STREAM, sendDocument.getDocumentName());
                }
            } else {
                builder.addTextBody("document", sendDocument.getDocument(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendDocument.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendDocument.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendDocument.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendDocument.getReplyToMessageId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendDocument.getCaption() != null) {
                builder.addTextBody("caption", sendDocument.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendDocument.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendDocument.getDisableNotification().toString(), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendDocument.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send document", e);
        }
    }

    @Override
    public final Message sendPhoto(SendPhoto sendPhoto) throws TelegramApiException {
        this.assertParamNotNull(sendPhoto, "sendPhoto");
        sendPhoto.validate();
        try {
            String url = this.getBaseUrl() + "sendphoto";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("chat_id", sendPhoto.getChatId());
            if (sendPhoto.isNewPhoto()) {
                if (sendPhoto.getNewPhotoFile() != null) {
                    builder.addBinaryBody("photo", sendPhoto.getNewPhotoFile());
                } else if (sendPhoto.getNewPhotoStream() != null) {
                    builder.addBinaryBody("photo", sendPhoto.getNewPhotoStream(), ContentType.APPLICATION_OCTET_STREAM, sendPhoto.getPhotoName());
                } else {
                    builder.addBinaryBody("photo", new java.io.File(sendPhoto.getPhoto()), ContentType.APPLICATION_OCTET_STREAM, sendPhoto.getPhotoName());
                }
            } else {
                builder.addTextBody("photo", sendPhoto.getPhoto());
            }
            if (sendPhoto.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendPhoto.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendPhoto.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendPhoto.getReplyToMessageId().toString());
            }
            if (sendPhoto.getCaption() != null) {
                builder.addTextBody("caption", sendPhoto.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendPhoto.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendPhoto.getDisableNotification().toString());
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendPhoto.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send photo", e);
        }
    }

    @Override
    public final Message sendVideo(SendVideo sendVideo) throws TelegramApiException {
        this.assertParamNotNull(sendVideo, "sendVideo");
        sendVideo.validate();
        try {
            String url = this.getBaseUrl() + "sendvideo";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("chat_id", sendVideo.getChatId());
            if (sendVideo.isNewVideo()) {
                if (sendVideo.getNewVideoFile() != null) {
                    builder.addBinaryBody("video", sendVideo.getNewVideoFile());
                } else if (sendVideo.getNewVideoStream() != null) {
                    builder.addBinaryBody("video", sendVideo.getNewVideoStream(), ContentType.APPLICATION_OCTET_STREAM, sendVideo.getVideoName());
                } else {
                    builder.addBinaryBody("video", new java.io.File(sendVideo.getVideo()), ContentType.APPLICATION_OCTET_STREAM, sendVideo.getVideoName());
                }
            } else {
                builder.addTextBody("video", sendVideo.getVideo());
            }
            if (sendVideo.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendVideo.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendVideo.getReplyToMessageId().toString());
            }
            if (sendVideo.getCaption() != null) {
                builder.addTextBody("caption", sendVideo.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideo.getDuration() != null) {
                builder.addTextBody("duration", sendVideo.getDuration().toString());
            }
            if (sendVideo.getWidth() != null) {
                builder.addTextBody("width", sendVideo.getWidth().toString());
            }
            if (sendVideo.getHeight() != null) {
                builder.addTextBody("height", sendVideo.getHeight().toString());
            }
            if (sendVideo.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendVideo.getDisableNotification().toString());
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendVideo.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send video", e);
        }
    }

    @Override
    public final Message sendVideoNote(SendVideoNote sendVideoNote) throws TelegramApiException {
        this.assertParamNotNull(sendVideoNote, "sendVideoNote");
        sendVideoNote.validate();
        try {
            String url = this.getBaseUrl() + "sendvideonote";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("chat_id", sendVideoNote.getChatId());
            if (sendVideoNote.isNewVideoNote()) {
                if (sendVideoNote.getNewVideoNoteFile() != null) {
                    builder.addBinaryBody("video_note", sendVideoNote.getNewVideoNoteFile());
                } else if (sendVideoNote.getNewVideoNoteStream() != null) {
                    builder.addBinaryBody("video_note", sendVideoNote.getNewVideoNoteStream(), ContentType.APPLICATION_OCTET_STREAM, sendVideoNote.getVideoNoteName());
                } else {
                    builder.addBinaryBody("video_note", new java.io.File(sendVideoNote.getVideoNote()), ContentType.APPLICATION_OCTET_STREAM, sendVideoNote.getVideoNoteName());
                }
            } else {
                builder.addTextBody("video_note", sendVideoNote.getVideoNote());
            }
            if (sendVideoNote.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendVideoNote.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVideoNote.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendVideoNote.getReplyToMessageId().toString());
            }
            if (sendVideoNote.getDuration() != null) {
                builder.addTextBody("duration", sendVideoNote.getDuration().toString());
            }
            if (sendVideoNote.getLength() != null) {
                builder.addTextBody("length", sendVideoNote.getLength().toString());
            }
            if (sendVideoNote.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendVideoNote.getDisableNotification().toString());
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendVideoNote.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send video note", e);
        }
    }

    @Override
    public final Message sendSticker(SendSticker sendSticker) throws TelegramApiException {
        this.assertParamNotNull(sendSticker, "sendSticker");
        sendSticker.validate();
        try {
            String url = this.getBaseUrl() + "sendsticker";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("chat_id", sendSticker.getChatId());
            if (sendSticker.isNewSticker()) {
                if (sendSticker.getNewStickerFile() != null) {
                    builder.addBinaryBody("sticker", sendSticker.getNewStickerFile());
                } else if (sendSticker.getNewStickerStream() != null) {
                    builder.addBinaryBody("sticker", sendSticker.getNewStickerStream(), ContentType.APPLICATION_OCTET_STREAM, sendSticker.getStickerName());
                } else {
                    builder.addBinaryBody("sticker", new java.io.File(sendSticker.getSticker()), ContentType.APPLICATION_OCTET_STREAM, sendSticker.getStickerName());
                }
            } else {
                builder.addTextBody("sticker", sendSticker.getSticker());
            }
            if (sendSticker.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendSticker.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendSticker.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendSticker.getReplyToMessageId().toString());
            }
            if (sendSticker.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendSticker.getDisableNotification().toString());
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendSticker.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send sticker", e);
        }
    }

    @Override
    public final Message sendAudio(SendAudio sendAudio) throws TelegramApiException {
        this.assertParamNotNull(sendAudio, "sendAudio");
        sendAudio.validate();
        try {
            String url = this.getBaseUrl() + "sendaudio";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("chat_id", sendAudio.getChatId());
            if (sendAudio.isNewAudio()) {
                if (sendAudio.getNewAudioFile() != null) {
                    builder.addBinaryBody("audio", sendAudio.getNewAudioFile());
                } else if (sendAudio.getNewAudioStream() != null) {
                    builder.addBinaryBody("audio", sendAudio.getNewAudioStream(), ContentType.APPLICATION_OCTET_STREAM, sendAudio.getAudioName());
                } else {
                    builder.addBinaryBody("audio", new java.io.File(sendAudio.getAudio()), ContentType.create("audio/mpeg"), sendAudio.getAudioName());
                }
            } else {
                builder.addTextBody("audio", sendAudio.getAudio());
            }
            if (sendAudio.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendAudio.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendAudio.getReplyToMessageId().toString());
            }
            if (sendAudio.getPerformer() != null) {
                builder.addTextBody("performer", sendAudio.getPerformer(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getTitle() != null) {
                builder.addTextBody("title", sendAudio.getTitle(), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendAudio.getDuration() != null) {
                builder.addTextBody("duration", sendAudio.getDuration().toString());
            }
            if (sendAudio.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendAudio.getDisableNotification().toString());
            }
            if (sendAudio.getCaption() != null) {
                builder.addTextBody("caption", sendAudio.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendAudio.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send sticker", e);
        }
    }

    @Override
    public final Message sendVoice(SendVoice sendVoice) throws TelegramApiException {
        this.assertParamNotNull(sendVoice, "sendVoice");
        sendVoice.validate();
        try {
            String url = this.getBaseUrl() + "sendvoice";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("chat_id", sendVoice.getChatId());
            if (sendVoice.isNewVoice()) {
                if (sendVoice.getNewVoiceFile() != null) {
                    builder.addBinaryBody("voice", sendVoice.getNewVoiceFile());
                } else if (sendVoice.getNewVoiceStream() != null) {
                    builder.addBinaryBody("voice", sendVoice.getNewVoiceStream(), ContentType.APPLICATION_OCTET_STREAM, sendVoice.getVoiceName());
                } else {
                    builder.addBinaryBody("voice", new java.io.File(sendVoice.getVoice()), ContentType.create("audio/ogg"), sendVoice.getVoiceName());
                }
            } else {
                builder.addTextBody("voice", sendVoice.getVoice());
            }
            if (sendVoice.getReplyMarkup() != null) {
                builder.addTextBody("reply_markup", this.objectMapper.writeValueAsString(sendVoice.getReplyMarkup()), TEXT_PLAIN_CONTENT_TYPE);
            }
            if (sendVoice.getReplyToMessageId() != null) {
                builder.addTextBody("reply_to_message_id", sendVoice.getReplyToMessageId().toString());
            }
            if (sendVoice.getDisableNotification() != null) {
                builder.addTextBody("disable_notification", sendVoice.getDisableNotification().toString());
            }
            if (sendVoice.getDuration() != null) {
                builder.addTextBody("duration", sendVoice.getDuration().toString());
            }
            if (sendVoice.getCaption() != null) {
                builder.addTextBody("caption", sendVoice.getCaption(), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return sendVoice.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to send voice", e);
        }
    }

    @Override
    public Boolean setChatPhoto(SetChatPhoto setChatPhoto) throws TelegramApiException {
        this.assertParamNotNull(setChatPhoto, "setChatPhoto");
        setChatPhoto.validate();
        try {
            String url = this.getBaseUrl() + "setChatPhoto";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("chat_id", setChatPhoto.getChatId());
            if (setChatPhoto.getPhoto() != null) {
                builder.addBinaryBody("photo", setChatPhoto.getPhoto());
            } else if (setChatPhoto.getPhotoStream() != null) {
                builder.addBinaryBody("photo", setChatPhoto.getPhotoStream(), ContentType.APPLICATION_OCTET_STREAM, setChatPhoto.getPhotoName());
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return setChatPhoto.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to set chat photo", e);
        }
    }

    @Override
    public Boolean addStickerToSet(AddStickerToSet addStickerToSet) throws TelegramApiException {
        this.assertParamNotNull(addStickerToSet, "addStickerToSet");
        addStickerToSet.validate();
        try {
            String url = this.getBaseUrl() + "addStickerToSet";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("user_id", addStickerToSet.getUserId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("name", addStickerToSet.getName(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("emojis", addStickerToSet.getEmojis(), TEXT_PLAIN_CONTENT_TYPE);
            if (addStickerToSet.isNewPngSticker().booleanValue()) {
                if (addStickerToSet.getPngStickerFile() != null) {
                    builder.addBinaryBody("png_sticker", addStickerToSet.getPngStickerFile());
                } else if (addStickerToSet.getPngStickerStream() != null) {
                    builder.addBinaryBody("png_sticker", addStickerToSet.getPngStickerStream(), ContentType.APPLICATION_OCTET_STREAM, addStickerToSet.getPngStickerName());
                } else {
                    builder.addBinaryBody("png_sticker", new java.io.File(addStickerToSet.getPngSticker()), ContentType.create("image/png"), addStickerToSet.getPngStickerName());
                }
            } else {
                builder.addTextBody("png_sticker", addStickerToSet.getPngSticker());
            }
            if (addStickerToSet.getMaskPosition() != null) {
                builder.addTextBody("mask_position", this.objectMapper.writeValueAsString(addStickerToSet.getMaskPosition()), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return addStickerToSet.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to add sticker to set", e);
        }
    }

    @Override
    public Boolean createNewStickerSet(CreateNewStickerSet createNewStickerSet) throws TelegramApiException {
        this.assertParamNotNull(createNewStickerSet, "createNewStickerSet");
        createNewStickerSet.validate();
        try {
            String url = this.getBaseUrl() + "createNewStickerSet";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("user_id", createNewStickerSet.getUserId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("name", createNewStickerSet.getName(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("title", createNewStickerSet.getTitle(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("emojis", createNewStickerSet.getEmojis(), TEXT_PLAIN_CONTENT_TYPE);
            builder.addTextBody("contains_masks", createNewStickerSet.getContainsMasks().toString());
            if (createNewStickerSet.isNewPngSticker().booleanValue()) {
                if (createNewStickerSet.getPngStickerFile() != null) {
                    builder.addBinaryBody("png_sticker", createNewStickerSet.getPngStickerFile());
                } else if (createNewStickerSet.getPngStickerStream() != null) {
                    builder.addBinaryBody("png_sticker", createNewStickerSet.getPngStickerStream(), ContentType.APPLICATION_OCTET_STREAM, createNewStickerSet.getPngStickerName());
                } else {
                    builder.addBinaryBody("png_sticker", new java.io.File(createNewStickerSet.getPngSticker()), ContentType.create("image/png"), createNewStickerSet.getPngStickerName());
                }
            } else {
                builder.addTextBody("png_sticker", createNewStickerSet.getPngSticker());
            }
            if (createNewStickerSet.getMaskPosition() != null) {
                builder.addTextBody("mask_position", this.objectMapper.writeValueAsString(createNewStickerSet.getMaskPosition()), TEXT_PLAIN_CONTENT_TYPE);
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return createNewStickerSet.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to create new sticker set", e);
        }
    }

    @Override
    public File uploadStickerFile(UploadStickerFile uploadStickerFile) throws TelegramApiException {
        this.assertParamNotNull(uploadStickerFile, "uploadStickerFile");
        uploadStickerFile.validate();
        try {
            String url = this.getBaseUrl() + "uploadStickerFile";
            HttpPost httppost = this.configuredHttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("name", uploadStickerFile.getUserId().toString(), TEXT_PLAIN_CONTENT_TYPE);
            if (uploadStickerFile.getNewPngStickerFile() != null) {
                builder.addBinaryBody("png_sticker", uploadStickerFile.getNewPngStickerFile());
            } else if (uploadStickerFile.getNewPngStickerStream() != null) {
                builder.addBinaryBody("png_sticker", uploadStickerFile.getNewPngStickerStream(), ContentType.APPLICATION_OCTET_STREAM, uploadStickerFile.getNewPngStickerName());
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            return uploadStickerFile.deserializeResponse(this.sendHttpPostRequest(httppost));
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to upload new sticker file", e);
        }
    }

    @Override
    protected final <T extends Serializable, Method extends BotApiMethod<T>, Callback extends SentCallback<T>> void sendApiMethodAsync(final Method method, final Callback callback) {
        this.exe.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    String responseContent = DefaultAbsSender.this.sendMethodRequest(method);
                    try {
                        callback.onResult(method, method.deserializeResponse(responseContent));
                    }
                    catch (TelegramApiRequestException e) {
                        callback.onError(method, e);
                    }
                }
                catch (IOException | TelegramApiValidationException e) {
                    callback.onException(method, e);
                }
            }
        });
    }

    @Override
    protected final <T extends Serializable, Method extends BotApiMethod<T>> T sendApiMethod(Method method) throws TelegramApiException {
        try {
            String responseContent = this.sendMethodRequest(method);
            return method.deserializeResponse(responseContent);
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to execute " + method.getMethod() + " method", e);
        }
    }

    private <T> Runnable getDownloadFileAsyncJob(final T fileIdentifier, final DownloadFileCallback<T> callback, final String url, final String tempFileName) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    callback.onResult(fileIdentifier, DefaultAbsSender.this.downloadToTemporaryFile(url, tempFileName));
                }
                catch (MalformedURLException e) {
                    callback.onException(fileIdentifier, new TelegramApiException("Wrong url for file: " + url));
                }
                catch (IOException e) {
                    callback.onException(fileIdentifier, new TelegramApiRequestException("Error downloading the file", e));
                }
            }
        };
    }

    private java.io.File downloadToTemporaryFileWrappingExceptions(String url, String tempFileName) throws TelegramApiException {
        try {
            return this.downloadToTemporaryFile(url, tempFileName);
        }
        catch (MalformedURLException e) {
            throw new TelegramApiException("Wrong url for file: " + url);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Error downloading the file", e);
        }
    }

    private java.io.File downloadToTemporaryFile(String url, String tempFileName) throws IOException {
        java.io.File output = java.io.File.createTempFile(tempFileName, ".tmp");
        FileUtils.copyURLToFile(new URL(url), output);
        return output;
    }

    private <T extends Serializable, Method extends BotApiMethod<T>> String sendMethodRequest(Method method) throws TelegramApiValidationException, IOException {
        method.validate();
        String url = this.getBaseUrl() + method.getMethod();
        HttpPost httppost = this.configuredHttpPost(url);
        httppost.addHeader("charset", StandardCharsets.UTF_8.name());
        httppost.setEntity(new StringEntity(this.objectMapper.writeValueAsString(method), ContentType.APPLICATION_JSON));
        return this.sendHttpPostRequest(httppost);
    }

    private String sendHttpPostRequest(HttpPost httppost) throws IOException {
        try (CloseableHttpResponse response = this.httpclient.execute(httppost);){
            HttpEntity ht = response.getEntity();
            BufferedHttpEntity buf = new BufferedHttpEntity(ht);
            String string = EntityUtils.toString((HttpEntity)buf, StandardCharsets.UTF_8);
            return string;
        }
    }

    private HttpPost configuredHttpPost(String url) {
        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(this.requestConfig);
        return httppost;
    }

    protected String getBaseUrl() {
        return this.options.getBaseUrl() + this.getBotToken() + "/";
    }

    private void assertParamNotNull(Object param, String paramName) throws TelegramApiException {
        if (param == null) {
            throw new TelegramApiException("Parameter " + paramName + " can not be null");
        }
    }
}

