/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.payments.LabeledPrice;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class SendInvoice
extends BotApiMethod<Message> {
    public static final String PATH = "sendinvoice";
    private static final String CHATID_FIELD = "chat_id";
    private static final String TITLE_FIELD = "title";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String PAYLOAD_FIELD = "payload";
    private static final String PROVIDER_TOKEN_FIELD = "provider_token";
    private static final String START_PARAMETER_FIELD = "start_parameter";
    private static final String CURRENCY_FIELD = "currency";
    private static final String PRICES_FIELD = "prices";
    private static final String PHOTO_URL_FIELD = "photo_url";
    private static final String PHOTO_SIZE_FIELD = "photo_size";
    private static final String PHOTO_WIDTH_FIELD = "photo_width";
    private static final String PHOTO_HEIGHT_FIELD = "photo_height";
    private static final String NEED_NAME_FIELD = "need_name";
    private static final String NEED_PHONE_NUMBER_FIELD = "need_phone_number";
    private static final String NEED_EMAIL_FIELD = "need_email";
    private static final String NEED_SHIPPING_ADDRESS_FIELD = "need_shipping_address";
    private static final String IS_FLEXIBLE_FIELD = "is_flexible";
    private static final String DISABLE_NOTIFICATION_FIELD = "disable_notification";
    private static final String REPLY_TO_MESSAGE_ID_FIELD = "reply_to_message_id";
    private static final String REPLY_MARKUP_FIELD = "reply_markup\t";
    @JsonProperty(value="chat_id")
    private Integer chatId;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="payload")
    private String payload;
    @JsonProperty(value="provider_token")
    private String providerToken;
    @JsonProperty(value="start_parameter")
    private String startParameter;
    @JsonProperty(value="currency")
    private String currency;
    @JsonProperty(value="prices")
    private List<LabeledPrice> prices;
    @JsonProperty(value="photo_url")
    private String photoUrl;
    @JsonProperty(value="photo_size")
    private Integer photoSize;
    @JsonProperty(value="photo_width")
    private Integer photoWidth;
    @JsonProperty(value="photo_height")
    private Integer photoHeight;
    @JsonProperty(value="need_name")
    private Boolean needName;
    @JsonProperty(value="need_phone_number")
    private Boolean needPhoneNumber;
    @JsonProperty(value="need_email")
    private Boolean needEmail;
    @JsonProperty(value="need_shipping_address")
    private Boolean needShippingAddress;
    @JsonProperty(value="is_flexible")
    private Boolean isFlexible;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="reply_markup\t")
    private InlineKeyboardMarkup replyMarkup;

    public SendInvoice() {
    }

    public SendInvoice(Integer chatId, String title, String description, String payload, String providerToken, String startParameter, String currency, List<LabeledPrice> prices) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.title = Preconditions.checkNotNull(title);
        this.description = Preconditions.checkNotNull(description);
        this.payload = Preconditions.checkNotNull(payload);
        this.providerToken = Preconditions.checkNotNull(providerToken);
        this.startParameter = Preconditions.checkNotNull(startParameter);
        this.currency = Preconditions.checkNotNull(currency);
        this.prices = Preconditions.checkNotNull(prices);
    }

    public Integer getChatId() {
        return this.chatId;
    }

    public SendInvoice setChatId(Integer chatId) {
        this.chatId = Preconditions.checkNotNull(chatId);
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public SendInvoice setTitle(String title) {
        this.title = Preconditions.checkNotNull(title);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public SendInvoice setDescription(String description) {
        this.description = Preconditions.checkNotNull(description);
        return this;
    }

    public String getPayload() {
        return this.payload;
    }

    public SendInvoice setPayload(String payload) {
        this.payload = Preconditions.checkNotNull(payload);
        return this;
    }

    public String getProviderToken() {
        return this.providerToken;
    }

    public SendInvoice setProviderToken(String providerToken) {
        this.providerToken = Preconditions.checkNotNull(providerToken);
        return this;
    }

    public String getStartParameter() {
        return this.startParameter;
    }

    public SendInvoice setStartParameter(String startParameter) {
        this.startParameter = Preconditions.checkNotNull(startParameter);
        return this;
    }

    public String getCurrency() {
        return this.currency;
    }

    public SendInvoice setCurrency(String currency) {
        this.currency = Preconditions.checkNotNull(currency);
        return this;
    }

    public List<LabeledPrice> getPrices() {
        return this.prices;
    }

    public SendInvoice setPrices(List<LabeledPrice> prices) {
        this.prices = Preconditions.checkNotNull(prices);
        return this;
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public SendInvoice setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
        return this;
    }

    public Integer getPhotoSize() {
        return this.photoSize;
    }

    public SendInvoice setPhotoSize(Integer photoSize) {
        this.photoSize = photoSize;
        return this;
    }

    public Integer getPhotoWidth() {
        return this.photoWidth;
    }

    public SendInvoice setPhotoWidth(Integer photoWidth) {
        this.photoWidth = photoWidth;
        return this;
    }

    public Integer getPhotoHeight() {
        return this.photoHeight;
    }

    public SendInvoice setPhotoHeight(Integer photoHeight) {
        this.photoHeight = photoHeight;
        return this;
    }

    public Boolean getNeedName() {
        return this.needName;
    }

    public SendInvoice setNeedName(Boolean needName) {
        this.needName = needName;
        return this;
    }

    public Boolean getNeedPhoneNumber() {
        return this.needPhoneNumber;
    }

    public SendInvoice setNeedPhoneNumber(Boolean needPhoneNumber) {
        this.needPhoneNumber = needPhoneNumber;
        return this;
    }

    public Boolean getNeedEmail() {
        return this.needEmail;
    }

    public SendInvoice setNeedEmail(Boolean needEmail) {
        this.needEmail = needEmail;
        return this;
    }

    public Boolean getNeedShippingAddress() {
        return this.needShippingAddress;
    }

    public SendInvoice setNeedShippingAddress(Boolean needShippingAddress) {
        this.needShippingAddress = needShippingAddress;
        return this;
    }

    public Boolean getFlexible() {
        return this.isFlexible;
    }

    public SendInvoice setFlexible(Boolean flexible) {
        this.isFlexible = flexible;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendInvoice setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendInvoice setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendInvoice setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return (Message)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending invoice", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.title == null || this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title parameter can't be empty", this);
        }
        if (this.description == null || this.description.isEmpty()) {
            throw new TelegramApiValidationException("Description parameter can't be empty", this);
        }
        if (this.payload == null || this.payload.isEmpty()) {
            throw new TelegramApiValidationException("Payload parameter can't be empty", this);
        }
        if (this.providerToken == null || this.providerToken.isEmpty()) {
            throw new TelegramApiValidationException("ProviderToken parameter can't be empty", this);
        }
        if (this.startParameter == null || this.startParameter.isEmpty()) {
            throw new TelegramApiValidationException("StartParameter parameter can't be empty", this);
        }
        if (this.currency == null || this.currency.isEmpty()) {
            throw new TelegramApiValidationException("Currency parameter can't be empty", this);
        }
        if (this.prices == null || this.prices.isEmpty()) {
            throw new TelegramApiValidationException("Prices parameter can't be empty", this);
        }
        for (LabeledPrice price : this.prices) {
            price.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public String toString() {
        return "SendInvoice{chatId='" + this.chatId + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", payload='" + this.payload + '\'' + ", providerToken='" + this.providerToken + '\'' + ", startParameter='" + this.startParameter + '\'' + ", currency='" + this.currency + '\'' + ", prices=" + this.prices + ", photoUrl='" + this.photoUrl + '\'' + ", photoSize=" + this.photoSize + ", photoWidth=" + this.photoWidth + ", photoHeight=" + this.photoHeight + ", needName=" + this.needName + ", needPhoneNumber=" + this.needPhoneNumber + ", needEmail=" + this.needEmail + ", needShippingAddress=" + this.needShippingAddress + ", isFlexible=" + this.isFlexible + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + '}';
    }
}

