/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.send;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.api.objects.Message;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class SendVideo
extends PartialBotApiMethod<Message> {
    public static final String PATH = "sendvideo";
    public static final String CHATID_FIELD = "chat_id";
    public static final String VIDEO_FIELD = "video";
    public static final String DURATION_FIELD = "duration";
    public static final String CAPTION_FIELD = "caption";
    public static final String WIDTH_FIELD = "width";
    public static final String HEIGHT_FIELD = "height";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String SUPPORTSSTREAMING_FIELD = "supports_streaming";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    public static final String PARSEMODE_FIELD = "parse_mode";
    private String chatId;
    private String video;
    private Integer duration;
    private String caption;
    private Integer width;
    private Integer height;
    private Boolean supportsStreaming;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private String parseMode;
    private boolean isNewVideo;
    private String videoName;
    private File newVideoFile;
    private InputStream newVideoStream;

    public String getChatId() {
        return this.chatId;
    }

    public SendVideo setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public String getVideo() {
        return this.video;
    }

    public SendVideo setVideo(String video) {
        this.video = video;
        this.isNewVideo = false;
        return this;
    }

    public SendVideo setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public SendVideo setDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public SendVideo setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendVideo setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendVideo setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public boolean isNewVideo() {
        return this.isNewVideo;
    }

    public String getVideoName() {
        return this.videoName;
    }

    public File getNewVideoFile() {
        return this.newVideoFile;
    }

    public InputStream getNewVideoStream() {
        return this.newVideoStream;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendVideo enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendVideo disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public Integer getWidth() {
        return this.width;
    }

    public SendVideo setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return this.height;
    }

    public SendVideo setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public SendVideo setNewVideo(File file) {
        this.isNewVideo = true;
        this.newVideoFile = file;
        return this;
    }

    public SendVideo setNewVideo(String videoName, InputStream inputStream) {
        Objects.requireNonNull(videoName, "videoName cannot be null!");
        Objects.requireNonNull(inputStream, "inputStream cannot be null!");
        this.videoName = videoName;
        this.isNewVideo = true;
        this.newVideoStream = inputStream;
        return this;
    }

    public Boolean getSupportsStreaming() {
        return this.supportsStreaming;
    }

    public SendVideo setSupportsStreaming(Boolean supportsStreaming) {
        this.supportsStreaming = supportsStreaming;
        return this;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public SendVideo setParseMode(String parseMode) {
        this.parseMode = parseMode;
        return this;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return (Message)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending video", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.isNewVideo) {
            if (this.newVideoFile == null && this.newVideoStream == null) {
                throw new TelegramApiValidationException("Video can't be empty", this);
            }
            if (this.newVideoStream != null && (this.videoName == null || this.videoName.isEmpty())) {
                throw new TelegramApiValidationException("Video name can't be empty", this);
            }
        } else if (this.video == null) {
            throw new TelegramApiValidationException("Video can't be empty", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public String toString() {
        return "SendVideo{chatId='" + this.chatId + '\'' + ", video='" + this.video + '\'' + ", duration=" + this.duration + ", caption='" + this.caption + '\'' + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", isNewVideo=" + this.isNewVideo + '}';
    }
}

