/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.telegram.telegrambots.api.interfaces.InputBotApiObject;
import org.telegram.telegrambots.api.interfaces.Validable;
import org.telegram.telegrambots.api.objects.games.CallbackGame;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class InlineKeyboardButton
implements InputBotApiObject,
Validable {
    private static final String TEXT_FIELD = "text";
    private static final String URL_FIELD = "url";
    private static final String CALLBACK_DATA_FIELD = "callback_data";
    private static final String CALLBACK_GAME_FIELD = "callback_game";
    private static final String SWITCH_INLINE_QUERY_FIELD = "switch_inline_query";
    private static final String SWITCH_INLINE_QUERY_CURRENT_CHAT_FIELD = "switch_inline_query_current_chat";
    private static final String PAY_FIELD = "pay";
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="callback_data")
    private String callbackData;
    @JsonProperty(value="callback_game")
    private CallbackGame callbackGame;
    @JsonProperty(value="switch_inline_query")
    private String switchInlineQuery;
    @JsonProperty(value="switch_inline_query_current_chat")
    private String switchInlineQueryCurrentChat;
    @JsonProperty(value="pay")
    private Boolean pay;

    public InlineKeyboardButton() {
    }

    public InlineKeyboardButton(String text) {
        this.text = Preconditions.checkNotNull(text);
    }

    public String getText() {
        return this.text;
    }

    public InlineKeyboardButton setText(String text) {
        this.text = text;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public InlineKeyboardButton setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getCallbackData() {
        return this.callbackData;
    }

    public InlineKeyboardButton setCallbackData(String callbackData) {
        this.callbackData = callbackData;
        return this;
    }

    public String getSwitchInlineQuery() {
        return this.switchInlineQuery;
    }

    public InlineKeyboardButton setSwitchInlineQuery(String switchInlineQuery) {
        this.switchInlineQuery = switchInlineQuery;
        return this;
    }

    public CallbackGame getCallbackGame() {
        return this.callbackGame;
    }

    public InlineKeyboardButton setCallbackGame(CallbackGame callbackGame) {
        this.callbackGame = callbackGame;
        return this;
    }

    public String getSwitchInlineQueryCurrentChat() {
        return this.switchInlineQueryCurrentChat;
    }

    public InlineKeyboardButton setSwitchInlineQueryCurrentChat(String switchInlineQueryCurrentChat) {
        this.switchInlineQueryCurrentChat = switchInlineQueryCurrentChat;
        return this;
    }

    public Boolean getPay() {
        return this.pay;
    }

    public InlineKeyboardButton setPay(Boolean pay) {
        this.pay = pay;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineKeyboardButton)) {
            return false;
        }
        InlineKeyboardButton inlineKeyboardButton = (InlineKeyboardButton)o;
        return Objects.equals(this.callbackData, inlineKeyboardButton.callbackData) && Objects.equals(this.callbackGame, inlineKeyboardButton.callbackGame) && Objects.equals(this.pay, inlineKeyboardButton.pay) && Objects.equals(this.switchInlineQuery, inlineKeyboardButton.switchInlineQuery) && Objects.equals(this.switchInlineQueryCurrentChat, inlineKeyboardButton.switchInlineQueryCurrentChat) && Objects.equals(this.text, inlineKeyboardButton.text) && Objects.equals(this.url, inlineKeyboardButton.url);
    }

    public int hashCode() {
        return Objects.hash(this.callbackData, this.callbackGame, this.pay, this.switchInlineQuery, this.switchInlineQueryCurrentChat, this.text, this.url);
    }

    public String toString() {
        return "InlineKeyboardButton{text='" + this.text + '\'' + ", url='" + this.url + '\'' + ", callbackData='" + this.callbackData + '\'' + ", callbackGame=" + this.callbackGame + ", switchInlineQuery='" + this.switchInlineQuery + '\'' + ", switchInlineQueryCurrentChat='" + this.switchInlineQueryCurrentChat + '\'' + ", pay=" + this.pay + '}';
    }
}

