/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetChatStickerSet
extends BotApiMethod<Boolean> {
    public static final String PATH = "setChatStickerSet";
    private static final String CHATID_FIELD = "chat_id";
    private static final String STICKERSETNAME_FIELD = "sticker_set_name";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="sticker_set_name")
    private String stickerSetName;

    public SetChatStickerSet() {
    }

    public SetChatStickerSet(String chatId, String stickerSetName) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.stickerSetName = Preconditions.checkNotNull(stickerSetName);
    }

    public SetChatStickerSet(Long chatId) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
    }

    public String getChatId() {
        return this.chatId;
    }

    public SetChatStickerSet setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SetChatStickerSet setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public String getStickerSetName() {
        return this.stickerSetName;
    }

    public SetChatStickerSet setStickerSetName(String stickerSetName) {
        Objects.requireNonNull(stickerSetName);
        this.stickerSetName = stickerSetName;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error setting chat sticker set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.stickerSetName == null || this.stickerSetName.isEmpty()) {
            throw new TelegramApiValidationException("StickerSetName can't be empty", this);
        }
    }

    public String toString() {
        return "SetChatStickerSet{chatId='" + this.chatId + '\'' + ", stickerSetName='" + this.stickerSetName + '\'' + '}';
    }
}

