/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendMessage
extends BotApiMethod<Message> {
    public static final String PATH = "sendmessage";
    private static final String CHATID_FIELD = "chat_id";
    private static final String TEXT_FIELD = "text";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String DISABLEWEBPAGEPREVIEW_FIELD = "disable_web_page_preview";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="disable_web_page_preview")
    private Boolean disableWebPagePreview;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="reply_markup")
    private ReplyKeyboard replyMarkup;

    public SendMessage() {
    }

    public SendMessage(String chatId, String text) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.text = Preconditions.checkNotNull(text);
    }

    public SendMessage(Long chatId, String text) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.text = Preconditions.checkNotNull(text);
    }

    public String getChatId() {
        return this.chatId;
    }

    public SendMessage setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SendMessage setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public String getText() {
        return this.text;
    }

    public SendMessage setText(String text) {
        this.text = text;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendMessage setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendMessage setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public Boolean getDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendMessage disableWebPagePreview() {
        this.disableWebPagePreview = true;
        return this;
    }

    public SendMessage enableWebPagePreview() {
        this.disableWebPagePreview = null;
        return this;
    }

    public SendMessage enableNotification() {
        this.disableNotification = null;
        return this;
    }

    public SendMessage disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public SendMessage setParseMode(String parseMode) {
        this.parseMode = parseMode;
        return this;
    }

    public SendMessage enableMarkdown(boolean enable) {
        this.parseMode = enable ? "Markdown" : null;
        return this;
    }

    public SendMessage enableHtml(boolean enable) {
        this.parseMode = enable ? "html" : null;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return (Message)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending message", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendMessage)) {
            return false;
        }
        SendMessage sendMessage = (SendMessage)o;
        return Objects.equals(this.chatId, sendMessage.chatId) && Objects.equals(this.disableNotification, sendMessage.disableNotification) && Objects.equals(this.disableWebPagePreview, sendMessage.disableWebPagePreview) && Objects.equals(this.parseMode, sendMessage.parseMode) && Objects.equals(this.replyMarkup, sendMessage.replyMarkup) && Objects.equals(this.replyToMessageId, sendMessage.replyToMessageId) && Objects.equals(this.text, sendMessage.text);
    }

    public int hashCode() {
        return Objects.hash(this.chatId, this.disableNotification, this.disableWebPagePreview, this.parseMode, this.replyMarkup, this.replyToMessageId, this.text);
    }

    public String toString() {
        return "SendMessage{chatId='" + this.chatId + '\'' + ", text='" + this.text + '\'' + ", parseMode='" + this.parseMode + '\'' + ", disableNotification='" + this.disableNotification + '\'' + ", disableWebPagePreview=" + this.disableWebPagePreview + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + '}';
    }
}

