/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.stickers.MaskPosition;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class AddStickerToSet
extends PartialBotApiMethod<Boolean> {
    public static final String PATH = "addStickerToSet";
    public static final String USERID_FIELD = "user_id";
    public static final String NAME_FIELD = "name";
    public static final String PNGSTICKER_FIELD = "png_sticker";
    public static final String EMOJIS_FIELD = "emojis";
    public static final String MASKPOSITION_FIELD = "mask_position";
    private Integer userId;
    private String name;
    private String emojis;
    private MaskPosition maskPosition;
    private InputFile pngSticker;

    public AddStickerToSet() {
    }

    public AddStickerToSet(Integer userId, String name, String emojis) {
        this.userId = Preconditions.checkNotNull(userId);
        this.name = Preconditions.checkNotNull(name);
        this.emojis = Preconditions.checkNotNull(emojis);
    }

    public Integer getUserId() {
        return this.userId;
    }

    public AddStickerToSet setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public InputFile getPngSticker() {
        return this.pngSticker;
    }

    public AddStickerToSet setPngSticker(String pngSticker) {
        this.pngSticker = new InputFile(pngSticker);
        return this;
    }

    public AddStickerToSet setPngSticker(File pngSticker) {
        Objects.requireNonNull(pngSticker, "pngSticker cannot be null!");
        this.pngSticker = new InputFile(pngSticker, pngSticker.getName());
        return this;
    }

    public AddStickerToSet setPngSticker(String pngStickerName, InputStream pngSticker) {
        Objects.requireNonNull(pngStickerName, "pngStickerName cannot be null!");
        Objects.requireNonNull(pngSticker, "pngSticker cannot be null!");
        this.pngSticker = new InputFile(pngSticker, pngStickerName);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public AddStickerToSet setName(String name) {
        this.name = name;
        return this;
    }

    public String getEmojis() {
        return this.emojis;
    }

    public AddStickerToSet setEmojis(String emojis) {
        this.emojis = emojis;
        return this;
    }

    public MaskPosition getMaskPosition() {
        return this.maskPosition;
    }

    public AddStickerToSet setMaskPosition(MaskPosition maskPosition) {
        this.maskPosition = maskPosition;
        return this;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error creating new sticker set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null || this.userId <= 0) {
            throw new TelegramApiValidationException("userId can't be empty", this);
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new TelegramApiValidationException("name can't be empty", this);
        }
        if (this.emojis == null || this.emojis.isEmpty()) {
            throw new TelegramApiValidationException("emojis can't be empty", this);
        }
        if (this.pngSticker == null) {
            throw new TelegramApiValidationException("PngSticker can't be empty", this);
        }
        this.pngSticker.validate();
        if (this.maskPosition != null) {
            this.maskPosition.validate();
        }
    }

    public String toString() {
        return "AddStickerToSet{userId=" + this.userId + ", name='" + this.name + '\'' + ", emojis='" + this.emojis + '\'' + ", maskPosition=" + this.maskPosition + ", pngSticker=" + this.pngSticker + '}';
    }
}

