/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.pinnedmessages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class PinChatMessage
extends BotApiMethod<Boolean> {
    public static final String PATH = "pinChatMessage";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;

    public PinChatMessage() {
    }

    public PinChatMessage(String chatId, Integer messageId) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.messageId = Preconditions.checkNotNull(messageId);
    }

    public PinChatMessage(Long chatId, Integer messageId) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.messageId = Preconditions.checkNotNull(messageId);
    }

    public String getChatId() {
        return this.chatId;
    }

    public PinChatMessage setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public PinChatMessage setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public PinChatMessage setMessageId(Integer messageId) {
        Objects.requireNonNull(messageId);
        this.messageId = messageId;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public PinChatMessage setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error pinning chat message", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.messageId == null) {
            throw new TelegramApiValidationException("MessageId parameter can't be null", this);
        }
    }

    public String toString() {
        return "PinChatMessage{chatId='" + this.chatId + '\'' + ", messageId=" + this.messageId + ", disableNotification=" + this.disableNotification + '}';
    }
}

