/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpUtils;
import org.glassfish.grizzly.utils.ArraySet;

public final class CompressionConfig {
    private CompressionMode compressionMode;
    private int compressionMinSize;
    private final ArraySet<String> compressableMimeTypes = new ArraySet<String>(String.class);
    private final ArraySet<String> noCompressionUserAgents = new ArraySet<String>(String.class);

    public CompressionConfig() {
        this.compressionMode = CompressionMode.OFF;
    }

    public CompressionConfig(CompressionConfig compression) {
        this.set(compression);
    }

    public CompressionConfig(CompressionMode compressionMode, int compressionMinSize, Set<String> compressableMimeTypes, Set<String> noCompressionUserAgents) {
        this.setCompressionMode(compressionMode);
        this.setCompressionMinSize(compressionMinSize);
        this.setCompressableMimeTypes(compressableMimeTypes);
        this.setNoCompressionUserAgents(noCompressionUserAgents);
    }

    public void set(CompressionConfig compression) {
        this.compressionMode = compression.compressionMode;
        this.compressionMinSize = compression.compressionMinSize;
        this.setCompressableMimeTypes(compression.compressableMimeTypes);
        this.setNoCompressionUserAgents(compression.noCompressionUserAgents);
    }

    public CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    public void setCompressionMode(CompressionMode mode) {
        this.compressionMode = mode != null ? mode : CompressionMode.OFF;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public Set<String> getCompressableMimeTypes() {
        return Collections.unmodifiableSet(this.compressableMimeTypes);
    }

    public void setCompressableMimeTypes(Set<String> compressableMimeTypes) {
        this.compressableMimeTypes.clear();
        if (compressableMimeTypes != null && !compressableMimeTypes.isEmpty()) {
            this.compressableMimeTypes.addAll((Collection<String>)compressableMimeTypes);
        }
    }

    public void setCompressableMimeTypes(String ... compressableMimeTypes) {
        this.compressableMimeTypes.clear();
        if (compressableMimeTypes.length > 0) {
            this.compressableMimeTypes.addAll((String[])compressableMimeTypes);
        }
    }

    public Set<String> getNoCompressionUserAgents() {
        return Collections.unmodifiableSet(this.noCompressionUserAgents);
    }

    public void setNoCompressionUserAgents(Set<String> noCompressionUserAgents) {
        this.noCompressionUserAgents.clear();
        if (noCompressionUserAgents != null && !noCompressionUserAgents.isEmpty()) {
            this.noCompressionUserAgents.addAll((Collection<String>)noCompressionUserAgents);
        }
    }

    public void setNoCompressionUserAgents(String ... noCompressionUserAgents) {
        this.noCompressionUserAgents.clear();
        if (noCompressionUserAgents.length > 0) {
            this.noCompressionUserAgents.addAll((String[])noCompressionUserAgents);
        }
    }

    public static boolean isClientSupportCompression(CompressionConfig compressionConfig, HttpRequestPacket request, String[] aliases) {
        CompressionMode mode = compressionConfig.getCompressionMode();
        switch (mode) {
            case OFF: {
                return false;
            }
        }
        if (Protocol.HTTP_1_1 != request.getProtocol()) {
            return false;
        }
        if (!CompressionConfig.isClientSupportContentEncoding(request, aliases)) {
            return false;
        }
        if (mode == CompressionMode.FORCE) {
            return true;
        }
        return compressionConfig.checkUserAgent(request);
    }

    public boolean checkUserAgent(HttpRequestPacket request) {
        DataChunk userAgentValueDC;
        return this.noCompressionUserAgents.isEmpty() || (userAgentValueDC = request.getHeaders().getValue(Header.UserAgent)) == null || CompressionConfig.indexOf(this.noCompressionUserAgents.getArray(), userAgentValueDC) == -1;
    }

    public boolean checkMimeType(String contentType) {
        if (!this.compressableMimeTypes.isEmpty()) {
            return CompressionConfig.indexOfStartsWith(this.compressableMimeTypes.getArray(), contentType) != -1;
        }
        return true;
    }

    private static boolean isClientSupportContentEncoding(HttpRequestPacket request, String[] aliases) {
        DataChunk acceptEncodingDC = request.getHeaders().getValue(Header.AcceptEncoding);
        if (acceptEncodingDC == null) {
            return false;
        }
        String alias = null;
        int idx = -1;
        int len = aliases.length;
        for (int i = 0; i < len && (idx = acceptEncodingDC.indexOf(alias = aliases[i], 0)) == -1; ++i) {
        }
        if (idx == -1) {
            return false;
        }
        assert (alias != null);
        int qvalueStart = acceptEncodingDC.indexOf(';', idx + alias.length());
        if (qvalueStart != -1) {
            int qvalueEnd;
            int commaIdx = acceptEncodingDC.indexOf(',', qvalueStart = acceptEncodingDC.indexOf('=', qvalueStart));
            int n = qvalueEnd = commaIdx != -1 ? commaIdx : acceptEncodingDC.getLength();
            if (HttpUtils.convertQValueToFloat(acceptEncodingDC, qvalueStart + 1, qvalueEnd) == 0.0f) {
                return false;
            }
        }
        return true;
    }

    private static int indexOf(String[] aliases, DataChunk dc) {
        if (dc == null || dc.isNull()) {
            return -1;
        }
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (dc.indexOf(alias, 0) == -1) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfStartsWith(String[] aliases, String s2) {
        if (s2 == null || s2.length() == 0) {
            return -1;
        }
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (!s2.startsWith(alias)) continue;
            return i;
        }
        return -1;
    }

    public static enum CompressionMode implements CompressionModeI
    {
        OFF,
        ON,
        FORCE;


        public static CompressionMode fromString(String mode) {
            if ("on".equalsIgnoreCase(mode)) {
                return ON;
            }
            if ("force".equalsIgnoreCase(mode)) {
                return FORCE;
            }
            if ("off".equalsIgnoreCase(mode)) {
                return OFF;
            }
            throw new IllegalArgumentException("Compression mode is not recognized. Supported modes: " + Arrays.toString(CompressionMode.values()));
        }
    }

    public static interface CompressionModeI {
    }
}

