/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class UploadStickerFile
extends PartialBotApiMethod<org.telegram.telegrambots.meta.api.objects.File> {
    public static final String PATH = "uploadStickerFile";
    public static final String USERID_FIELD = "user_id";
    public static final String PNGSTICKER_FIELD = "png_sticker";
    private Integer userId;
    private InputFile pngSticker;

    public UploadStickerFile() {
    }

    public UploadStickerFile(Integer userId) {
        this.userId = Preconditions.checkNotNull(userId);
    }

    @Override
    public org.telegram.telegrambots.meta.api.objects.File deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<org.telegram.telegrambots.meta.api.objects.File>>(){});
            if (result.getOk().booleanValue()) {
                return (org.telegram.telegrambots.meta.api.objects.File)result.getResult();
            }
            throw new TelegramApiRequestException("Error uploading sticker set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null || this.userId <= 0) {
            throw new TelegramApiValidationException("userId can't be empty", this);
        }
        if (this.pngSticker == null) {
            throw new TelegramApiValidationException("PngSticker parameter can't be empty", this);
        }
        this.pngSticker.validate();
    }

    public Integer getUserId() {
        return this.userId;
    }

    public UploadStickerFile setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public InputFile getPngSticker() {
        return this.pngSticker;
    }

    public UploadStickerFile setPngSticker(File pngSticker) {
        this.pngSticker = new InputFile(pngSticker, pngSticker.getName());
        return this;
    }

    public UploadStickerFile setPngSticker(String pngStickerName, InputStream pngStickerStream) {
        this.pngSticker = new InputFile(pngStickerStream, pngStickerName);
        return this;
    }

    public String toString() {
        return "UploadStickerFile{userId=" + this.userId + ", pngSticker=" + this.pngSticker + '}';
    }
}

