/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.facilities.proxysocketfactorys;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import sun.net.SocksProxy;

public class SocksSSLConnectionSocketFactory
extends SSLConnectionSocketFactory {
    public SocksSSLConnectionSocketFactory(SSLContext sslContext) {
        super(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
    }

    public Socket createSocket(HttpContext context) throws IOException {
        InetSocketAddress socksaddr = (InetSocketAddress)context.getAttribute("socketAddress");
        int socksVersion = (Integer)context.getAttribute("socksVersion");
        SocksProxy proxy = SocksProxy.create(socksaddr, socksVersion);
        return new Socket(proxy);
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        String hostName = host.getHostName();
        int port = remoteAddress.getPort();
        InetSocketAddress unresolvedRemote = InetSocketAddress.createUnresolved(hostName, port);
        return super.connectSocket(connectTimeout, socket, host, unresolvedRemote, localAddress, context);
    }
}

