/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class AnswerPreCheckoutQuery
extends BotApiMethod<Boolean> {
    public static final String PATH = "answerPreCheckoutQuery";
    private static final String PRE_CHECKOUT_QUERY_ID_FIELD = "pre_checkout_query_id";
    private static final String OK_FIELD = "ok";
    private static final String ERROR_MESSAGE_FIELD = "error_message";
    @JsonProperty(value="pre_checkout_query_id")
    private String preCheckoutQueryId;
    @JsonProperty(value="ok")
    private Boolean ok;
    @JsonProperty(value="error_message")
    private String errorMessage;

    public AnswerPreCheckoutQuery() {
    }

    public AnswerPreCheckoutQuery(String preCheckoutQueryId, Boolean ok) {
        this.preCheckoutQueryId = Preconditions.checkNotNull(preCheckoutQueryId);
        this.ok = Preconditions.checkNotNull(ok);
    }

    public String getPreCheckoutQueryId() {
        return this.preCheckoutQueryId;
    }

    public AnswerPreCheckoutQuery setPreCheckoutQueryId(String preCheckoutQueryId) {
        this.preCheckoutQueryId = Preconditions.checkNotNull(preCheckoutQueryId);
        return this;
    }

    public Boolean getOk() {
        return this.ok;
    }

    public AnswerPreCheckoutQuery setOk(Boolean ok) {
        this.ok = Preconditions.checkNotNull(ok);
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public AnswerPreCheckoutQuery setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.preCheckoutQueryId == null || this.preCheckoutQueryId.isEmpty()) {
            throw new TelegramApiValidationException("PreCheckoutQueryId can't be empty", this);
        }
        if (this.ok == null) {
            throw new TelegramApiValidationException("Ok can't be null", this);
        }
        if (!this.ok.booleanValue() && (this.errorMessage == null || this.errorMessage.isEmpty())) {
            throw new TelegramApiValidationException("ErrorMessage can't be empty if not ok", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error answering pre-checkout query", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    public String toString() {
        return "AnswerPreCheckoutQuery{preCheckoutQueryId='" + this.preCheckoutQueryId + '\'' + ", ok=" + this.ok + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }
}

