/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class RestrictChatMember
extends BotApiMethod<Boolean> {
    public static final String PATH = "restrictchatmember";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USER_ID_FIELD = "user_id";
    private static final String UNTILDATE_FIELD = "until_date";
    private static final String CANSENDMESSAGES_FIELD = "can_send_messages";
    private static final String CANSENDMEDIAMESSAGES_FIELD = "can_send_media_messages";
    private static final String CANSENDOTHERMESSAGES_FIELD = "can_send_other_messages";
    private static final String CANADDWEBPAGEPREVIEWS_FIELD = "can_add_web_page_previews";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="user_id")
    private Integer userId;
    @JsonProperty(value="until_date")
    private Integer untilDate;
    @JsonProperty(value="can_send_messages")
    private Boolean canSendMessages;
    @JsonProperty(value="can_send_media_messages")
    private Boolean canSendMediaMessages;
    @JsonProperty(value="can_send_other_messages")
    private Boolean canSendOtherMessages;
    @JsonProperty(value="can_add_web_page_previews")
    private Boolean canAddWebPagePreviews;

    public RestrictChatMember() {
    }

    public RestrictChatMember(String chatId, Integer userId) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.userId = Preconditions.checkNotNull(userId);
    }

    public RestrictChatMember(Long chatId, Integer userId) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.userId = Preconditions.checkNotNull(userId);
    }

    public String getChatId() {
        return this.chatId;
    }

    public RestrictChatMember setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public RestrictChatMember setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public RestrictChatMember setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public Integer getUntilDate() {
        return this.untilDate;
    }

    public RestrictChatMember setUntilDate(Integer untilDateInSeconds) {
        this.untilDate = untilDateInSeconds;
        return this;
    }

    @JsonIgnore
    public RestrictChatMember setUntilDate(Instant instant) {
        return this.setUntilDate((int)instant.getEpochSecond());
    }

    @JsonIgnore
    public RestrictChatMember setUntilDate(ZonedDateTime date) {
        return this.setUntilDate(date.toInstant());
    }

    public RestrictChatMember forTimePeriod(Duration duration) {
        return this.setUntilDate(Instant.now().plusMillis(duration.toMillis()));
    }

    public Boolean getCanSendMessages() {
        return this.canSendMessages;
    }

    public RestrictChatMember setCanSendMessages(Boolean canSendMessages) {
        this.canSendMessages = canSendMessages;
        return this;
    }

    public Boolean getCanSendMediaMessages() {
        return this.canSendMediaMessages;
    }

    public RestrictChatMember setCanSendMediaMessages(Boolean canSendMediaMessages) {
        this.canSendMediaMessages = canSendMediaMessages;
        return this;
    }

    public Boolean getCanSendOtherMessages() {
        return this.canSendOtherMessages;
    }

    public RestrictChatMember setCanSendOtherMessages(Boolean canSendOtherMessages) {
        this.canSendOtherMessages = canSendOtherMessages;
        return this;
    }

    public Boolean getCanAddWebPagePreviews() {
        return this.canAddWebPagePreviews;
    }

    public RestrictChatMember setCanAddWebPagePreviews(Boolean canAddWebPagePreviews) {
        this.canAddWebPagePreviews = canAddWebPagePreviews;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error restricting chat member", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId can't be empty", this);
        }
    }

    public String toString() {
        return "RestrictChatMember{chatId='" + this.chatId + '\'' + ", userId=" + this.userId + ", untilDate=" + this.untilDate + ", canSendMessages=" + this.canSendMessages + ", canSendMediaMessages=" + this.canSendMediaMessages + ", canSendOtherMessages=" + this.canSendOtherMessages + ", canAddWebPagePreviews=" + this.canAddWebPagePreviews + '}';
    }
}

