/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.passport.dataerror;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class PassportElementErrorFiles
implements PassportElementError {
    private static final String SOURCE_FIELD = "source";
    private static final String TYPE_FIELD = "type";
    private static final String FILEHASHES_FIELD = "file_hashes";
    private static final String MESSAGE_FIELD = "message";
    @JsonProperty(value="source")
    private final String source = "file";
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="file_hashes")
    private List<String> fileHashes;
    @JsonProperty(value="message")
    private String message;

    public PassportElementErrorFiles() {
    }

    public PassportElementErrorFiles(String type, List<String> fileHashes, String message) {
        this.type = Preconditions.checkNotNull(type);
        this.fileHashes = Preconditions.checkNotNull(fileHashes);
        this.message = Preconditions.checkNotNull(message);
    }

    public String getType() {
        return this.type;
    }

    public PassportElementErrorFiles setType(String type) {
        this.type = Preconditions.checkNotNull(type);
        return this;
    }

    public String getSource() {
        return "file";
    }

    public List<String> getFileHashes() {
        return this.fileHashes;
    }

    public PassportElementErrorFiles setFileHashes(List<String> fileHashes) {
        this.fileHashes = Preconditions.checkNotNull(fileHashes);
        return this;
    }

    public PassportElementErrorFiles addFileHash(String fileHash) {
        fileHash = Preconditions.checkNotNull(fileHash);
        if (this.fileHashes == null) {
            this.fileHashes = new ArrayList<String>();
        }
        this.fileHashes.add(fileHash);
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public PassportElementErrorFiles setMessage(String message) {
        this.message = Preconditions.checkNotNull(message);
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.fileHashes == null || this.fileHashes.isEmpty()) {
            throw new TelegramApiValidationException("File hash parameter can't be empty", this);
        }
        if (this.message == null || this.message.isEmpty()) {
            throw new TelegramApiValidationException("Message parameter can't be empty", this);
        }
        if (this.type == null || this.type.isEmpty()) {
            throw new TelegramApiValidationException("Type parameter can't be empty", this);
        }
    }

    public String toString() {
        return "PassportElementErrorFile{source='file', type='" + this.type + '\'' + ", fileHashes='" + this.fileHashes + '\'' + ", message='" + this.message + '\'' + '}';
    }
}

