/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.UserProfilePhotos;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class GetUserProfilePhotos
extends BotApiMethod<UserProfilePhotos> {
    public static final String PATH = "getuserprofilephotos";
    private static final String USERID_FIELD = "user_id";
    private static final String OFFSET_FIELD = "offset";
    private static final String LIMIT_FIELD = "limit";
    @JsonProperty(value="user_id")
    private Integer userId;
    @JsonProperty(value="offset")
    private Integer offset;
    @JsonProperty(value="limit")
    private Integer limit;

    public Integer getUserId() {
        return this.userId;
    }

    public GetUserProfilePhotos setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public GetUserProfilePhotos setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public GetUserProfilePhotos setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public UserProfilePhotos deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<UserProfilePhotos>>(){});
            if (result.getOk().booleanValue()) {
                return (UserProfilePhotos)result.getResult();
            }
            throw new TelegramApiRequestException("Error getting user profile photos", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId parameter can't be empty", this);
        }
    }

    public String toString() {
        return "GetUserProfilePhotos{userId=" + this.userId + ", offset=" + this.offset + ", limit=" + this.limit + '}';
    }
}

