/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.ChatPermissions;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetChatPermissions
extends BotApiMethod<Boolean> {
    public static final String PATH = "setChatPermissions";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String PERMISSIONS_FIELD = "permissions";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="permissions")
    private ChatPermissions permissions;

    public SetChatPermissions() {
    }

    public SetChatPermissions(String chatId, ChatPermissions permissions) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.permissions = Preconditions.checkNotNull(permissions);
    }

    public SetChatPermissions(Long chatId, ChatPermissions permissions) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.permissions = Preconditions.checkNotNull(permissions);
    }

    public String getChatId() {
        return this.chatId;
    }

    public SetChatPermissions setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SetChatPermissions setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public ChatPermissions getPermissions() {
        return this.permissions;
    }

    public SetChatPermissions setPermissions(ChatPermissions permissions) {
        Objects.requireNonNull(permissions);
        this.permissions = permissions;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error setting chat description", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.permissions == null) {
            throw new TelegramApiValidationException("Permissions can't be null", this);
        }
    }

    public String toString() {
        return "SetChatPermissions{chatId='" + this.chatId + '\'' + ", permissions=" + this.permissions + '}';
    }
}

