/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class UnbanChatMember
extends BotApiMethod<Boolean> {
    public static final String PATH = "unbanchatmember";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USER_ID_FIELD = "user_id";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="user_id")
    private Integer userId;

    public UnbanChatMember() {
    }

    public UnbanChatMember(String chatId, Integer userId) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.userId = Preconditions.checkNotNull(userId);
    }

    public UnbanChatMember(Long chatId, Integer userId) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.userId = Preconditions.checkNotNull(userId);
    }

    public String getChatId() {
        return this.chatId;
    }

    public UnbanChatMember setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public UnbanChatMember setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public UnbanChatMember setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error unbanning chat member", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId can't be null", this);
        }
    }

    public String toString() {
        return "UnbanChatMember{chatId='" + this.chatId + '\'' + ", userId='" + this.userId + '}';
    }
}

