/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAnimation;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAudio;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaDocument;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaPhoto;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaVideo;

public class InputMediaDeserializer
extends StdDeserializer<InputMedia> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public InputMediaDeserializer() {
        this((Class<?>)null);
    }

    public InputMediaDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public InputMedia deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        switch (node.get("type").asText()) {
            case "photo": {
                return (InputMedia)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InputMediaPhoto>(){});
            }
            case "video": {
                return (InputMedia)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InputMediaVideo>(){});
            }
            case "animation": {
                return (InputMedia)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InputMediaAnimation>(){});
            }
            case "audio": {
                return (InputMedia)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InputMediaAudio>(){});
            }
            case "document": {
                return (InputMedia)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InputMediaDocument>(){});
            }
        }
        return null;
    }
}

