/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ForceReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboardRemove;

public class KeyboardDeserializer
extends StdDeserializer<ReplyKeyboard> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public KeyboardDeserializer() {
        this((Class<?>)null);
    }

    private KeyboardDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public ReplyKeyboard deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (node.has("force_reply")) {
            return (ReplyKeyboard)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<ForceReplyKeyboard>(){});
        }
        if (node.has("keyboard")) {
            return (ReplyKeyboard)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<ReplyKeyboardMarkup>(){});
        }
        if (node.has("inline_keyboard")) {
            return (ReplyKeyboard)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<InlineKeyboardMarkup>(){});
        }
        if (node.has("remove_keyboard")) {
            return (ReplyKeyboard)this.objectMapper.readValue(node.toString(), (TypeReference)new TypeReference<ReplyKeyboardRemove>(){});
        }
        return null;
    }
}

