/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.polls;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendPoll
extends BotApiMethod<Message> {
    public static final String PATH = "sendPoll";
    private static final String CHATID_FIELD = "chat_id";
    private static final String QUESTION_FIELD = "question";
    private static final String OPTIONS_FIELD = "options";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="question")
    private String question;
    @JsonProperty(value="options")
    private List<String> options;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="reply_markup")
    private ReplyKeyboard replyMarkup;

    public SendPoll() {
    }

    public SendPoll(String chatId, String question, List<String> options) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.question = Preconditions.checkNotNull(question);
        this.options = Preconditions.checkNotNull(options);
    }

    public SendPoll(Long chatId, String question, List<String> options) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.question = Preconditions.checkNotNull(question);
        this.options = Preconditions.checkNotNull(options);
    }

    public String getChatId() {
        return this.chatId;
    }

    public SendPoll setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SendPoll setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public String getQuestion() {
        return this.question;
    }

    public SendPoll setQuestion(String question) {
        this.question = question;
        return this;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public SendPoll setOptions(List<String> options) {
        this.options = options;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendPoll setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendPoll setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendPoll enableNotification() {
        this.disableNotification = null;
        return this;
    }

    public SendPoll disableNotification() {
        this.disableNotification = true;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Message> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error sending poll", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.question == null || this.question.isEmpty()) {
            throw new TelegramApiValidationException("Question parameter can't be empty", this);
        }
        if (this.options == null || this.options.isEmpty()) {
            throw new TelegramApiValidationException("Options parameter can't be empty", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendPoll)) {
            return false;
        }
        SendPoll sendMessage = (SendPoll)o;
        return Objects.equals(this.chatId, sendMessage.chatId) && Objects.equals(this.disableNotification, sendMessage.disableNotification) && Objects.equals(this.question, sendMessage.question) && Objects.equals(this.options, sendMessage.options) && Objects.equals(this.replyMarkup, sendMessage.replyMarkup) && Objects.equals(this.replyToMessageId, sendMessage.replyToMessageId);
    }

    public int hashCode() {
        return Objects.hash(this.chatId, this.disableNotification, this.options, this.replyMarkup, this.replyToMessageId, this.question);
    }

    public String toString() {
        return "SendPoll{chatId='" + this.chatId + '\'' + ", question='" + this.question + '\'' + ", options=" + this.options + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + '}';
    }
}

