/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendVideoNote
extends PartialBotApiMethod<Message> {
    public static final String PATH = "sendvideonote";
    public static final String CHATID_FIELD = "chat_id";
    public static final String VIDEONOTE_FIELD = "video_note";
    public static final String DURATION_FIELD = "duration";
    public static final String LENGTH_FIELD = "length";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    public static final String THUMB_FIELD = "thumb";
    private String chatId;
    private InputFile videoNote;
    private Integer duration;
    private Integer length;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private InputFile thumb;

    public SendVideoNote() {
    }

    public SendVideoNote(String chatId, String videoNote) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.setVideoNote(Preconditions.checkNotNull(videoNote));
    }

    public SendVideoNote(Long chatId, String videoNote) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.setVideoNote(Preconditions.checkNotNull(videoNote));
    }

    public SendVideoNote(String chatId, File videoNote) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.setVideoNote(videoNote);
    }

    public SendVideoNote(Integer chatId, File videoNote) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.setVideoNote(videoNote);
    }

    public SendVideoNote(String chatId, String videoNoteName, InputStream videoNote) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.setVideoNote(videoNoteName, videoNote);
    }

    public SendVideoNote(Integer chatId, String videoNoteName, InputStream videoNote) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.setVideoNote(videoNoteName, videoNote);
    }

    public String getChatId() {
        return this.chatId;
    }

    public SendVideoNote setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public InputFile getVideoNote() {
        return this.videoNote;
    }

    public SendVideoNote setVideoNote(String videoNote) {
        this.videoNote = new InputFile(videoNote);
        return this;
    }

    public Integer getLength() {
        return this.length;
    }

    public SendVideoNote setLength(Integer length) {
        this.length = length;
        return this;
    }

    public SendVideoNote setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public SendVideoNote setDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendVideoNote setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendVideoNote setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendVideoNote enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendVideoNote disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public SendVideoNote setVideoNote(InputFile videoNote) {
        Objects.requireNonNull(videoNote, "videoNote cannot be null!");
        this.videoNote = videoNote;
        return this;
    }

    public SendVideoNote setVideoNote(File file) {
        Objects.requireNonNull(file, "file cannot be null!");
        this.videoNote = new InputFile(file, file.getName());
        return this;
    }

    public SendVideoNote setVideoNote(String videoName, InputStream inputStream) {
        Objects.requireNonNull(videoName, "videoName cannot be null!");
        Objects.requireNonNull(inputStream, "inputStream cannot be null!");
        this.videoNote = new InputFile(inputStream, videoName);
        return this;
    }

    public InputFile getThumb() {
        return this.thumb;
    }

    public SendVideoNote setThumb(InputFile thumb) {
        this.thumb = thumb;
        return this;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Message> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error sending video note", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.videoNote == null) {
            throw new TelegramApiValidationException("VideoNote parameter can't be empty", this);
        }
        this.videoNote.validate();
        if (this.thumb != null) {
            this.thumb.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public String toString() {
        return "SendVideoNote{chatId='" + this.chatId + '\'' + ", videoNote=" + this.videoNote + ", duration=" + this.duration + ", length=" + this.length + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", thumb=" + this.thumb + '}';
    }
}

