/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.passport.dataerror;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class PassportElementErrorDataField
implements PassportElementError {
    private static final String SOURCE_FIELD = "source";
    private static final String TYPE_FIELD = "type";
    private static final String FIELDNAME_FIELD = "field_name";
    private static final String DATAHASH_FIELD = "data_hash";
    private static final String MESSAGE_FIELD = "message";
    @JsonProperty(value="source")
    private final String source = "data";
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="field_name")
    private String fieldName;
    @JsonProperty(value="data_hash")
    private String dataHash;
    @JsonProperty(value="message")
    private String message;

    public PassportElementErrorDataField() {
    }

    public PassportElementErrorDataField(String type, String fieldName, String dataHash, String message) {
        this.type = Preconditions.checkNotNull(type);
        this.fieldName = Preconditions.checkNotNull(fieldName);
        this.dataHash = Preconditions.checkNotNull(dataHash);
        this.message = Preconditions.checkNotNull(message);
    }

    public String getType() {
        return this.type;
    }

    public PassportElementErrorDataField setType(String type) {
        this.type = Preconditions.checkNotNull(type);
        return this;
    }

    public String getSource() {
        return "data";
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public PassportElementErrorDataField setFieldName(String fieldName) {
        this.fieldName = Preconditions.checkNotNull(fieldName);
        return this;
    }

    public String getDataHash() {
        return this.dataHash;
    }

    public PassportElementErrorDataField setDataHash(String dataHash) {
        this.dataHash = Preconditions.checkNotNull(dataHash);
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public PassportElementErrorDataField setMessage(String message) {
        this.message = Preconditions.checkNotNull(message);
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.fieldName == null || this.fieldName.isEmpty()) {
            throw new TelegramApiValidationException("Field Name parameter can't be empty", this);
        }
        if (this.dataHash == null || this.dataHash.isEmpty()) {
            throw new TelegramApiValidationException("Data hash parameter can't be empty", this);
        }
        if (this.message == null || this.message.isEmpty()) {
            throw new TelegramApiValidationException("Message parameter can't be empty", this);
        }
        if (this.type == null || this.type.isEmpty()) {
            throw new TelegramApiValidationException("Type parameter can't be empty", this);
        }
    }

    public String toString() {
        return "PassportElementErrorDataField{source='data', type='" + this.type + '\'' + ", fieldName='" + this.fieldName + '\'' + ", dataHash='" + this.dataHash + '\'' + ", message='" + this.message + '\'' + '}';
    }
}

