/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.payments;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import org.telegram.telegrambots.meta.api.interfaces.InputBotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.payments.LabeledPrice;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class ShippingOption
implements InputBotApiObject,
Validable {
    private static final String ID_FIELD = "id";
    private static final String TITLE_FIELD = "title";
    private static final String PRICES_FIELD = "prices";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="prices")
    private List<LabeledPrice> prices;

    public ShippingOption() {
    }

    public ShippingOption(String id, String title, List<LabeledPrice> prices) {
        this.id = Preconditions.checkNotNull(id);
        this.title = Preconditions.checkNotNull(title);
        this.prices = Preconditions.checkNotNull(prices);
    }

    public String getId() {
        return this.id;
    }

    public ShippingOption setId(String id) {
        this.id = Preconditions.checkNotNull(id);
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public ShippingOption setTitle(String title) {
        this.title = Preconditions.checkNotNull(title);
        return this;
    }

    public List<LabeledPrice> getPrices() {
        return this.prices;
    }

    public ShippingOption setPrices(List<LabeledPrice> prices) {
        this.prices = Preconditions.checkNotNull(prices);
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id == null || this.id.isEmpty()) {
            throw new TelegramApiValidationException("Id parameter can't be empty", this);
        }
        if (this.title == null || this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title parameter can't be empty", this);
        }
        if (this.prices == null || this.prices.isEmpty()) {
            throw new TelegramApiValidationException("Prices parameter can't be empty", this);
        }
        for (LabeledPrice price : this.prices) {
            price.validate();
        }
    }

    public String toString() {
        return "ShippingOption{id='" + this.id + '\'' + ", title='" + this.title + '\'' + ", prices=" + this.prices + '}';
    }
}

