/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendAnimation
extends PartialBotApiMethod<Message> {
    public static final String PATH = "sendAnimation";
    public static final String CHATID_FIELD = "chat_id";
    public static final String ANIMATION_FIELD = "animation";
    public static final String DURATION_FIELD = "duration";
    public static final String WIDTH_FIELD = "width";
    public static final String HEIGHT_FIELD = "height";
    public static final String CAPTION_FIELD = "caption";
    public static final String PARSEMODE_FIELD = "parse_mode";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    public static final String THUMB_FIELD = "thumb";
    private String chatId;
    private InputFile animation;
    private Integer duration;
    private String caption;
    private Integer width;
    private Integer height;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private String parseMode;
    private InputFile thumb;

    public String getChatId() {
        return this.chatId;
    }

    public SendAnimation setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public InputFile getAnimation() {
        return this.animation;
    }

    public SendAnimation setAnimation(String animation) {
        this.animation = new InputFile(animation);
        return this;
    }

    public SendAnimation setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public SendAnimation setDuration(Integer duration) {
        this.duration = duration;
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public SendAnimation setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendAnimation setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendAnimation setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendAnimation enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendAnimation disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public Integer getWidth() {
        return this.width;
    }

    public SendAnimation setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getHeight() {
        return this.height;
    }

    public SendAnimation setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public SendAnimation setAnimation(File file) {
        this.animation = new InputFile(file, file.getName());
        return this;
    }

    public SendAnimation setAnimation(String animationName, InputStream inputStream) {
        Objects.requireNonNull(animationName, "animationName cannot be null!");
        Objects.requireNonNull(inputStream, "inputStream cannot be null!");
        this.animation = new InputFile(inputStream, animationName);
        return this;
    }

    public SendAnimation setAnimation(InputFile animation) {
        Objects.requireNonNull(animation, "animation cannot be null!");
        this.animation = animation;
        return this;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public SendAnimation setParseMode(String parseMode) {
        this.parseMode = parseMode;
        return this;
    }

    public InputFile getThumb() {
        return this.thumb;
    }

    public SendAnimation setThumb(InputFile thumb) {
        this.thumb = thumb;
        return this;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Message> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error sending animation", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.animation == null) {
            throw new TelegramApiValidationException("Animation parameter can't be empty", this);
        }
        this.animation.validate();
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.thumb != null) {
            this.thumb.validate();
        }
    }

    public String toString() {
        return "SendAnimation{chatId='" + this.chatId + '\'' + ", animation=" + this.animation + ", duration=" + this.duration + ", caption='" + this.caption + '\'' + ", width=" + this.width + ", height=" + this.height + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", parseMode='" + this.parseMode + '\'' + ", thumb=" + this.thumb + '}';
    }
}

