/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InlineKeyboardMarkup
implements ReplyKeyboard {
    private static final String KEYBOARD_FIELD = "inline_keyboard";
    @JsonProperty(value="inline_keyboard")
    private List<List<InlineKeyboardButton>> keyboard;

    public InlineKeyboardMarkup() {
        this.keyboard = new ArrayList<List<InlineKeyboardButton>>();
    }

    public InlineKeyboardMarkup(List<List<InlineKeyboardButton>> keyboard) {
        this.keyboard = keyboard;
    }

    public List<List<InlineKeyboardButton>> getKeyboard() {
        return this.keyboard;
    }

    public InlineKeyboardMarkup setKeyboard(List<List<InlineKeyboardButton>> keyboard) {
        this.keyboard = keyboard;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.keyboard == null) {
            throw new TelegramApiValidationException("Keyboard parameter can't be null", this);
        }
        for (List<InlineKeyboardButton> inlineKeyboardButtons : this.keyboard) {
            for (InlineKeyboardButton inlineKeyboardButton : inlineKeyboardButtons) {
                inlineKeyboardButton.validate();
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineKeyboardMarkup)) {
            return false;
        }
        InlineKeyboardMarkup inlineKeyboardMarkup = (InlineKeyboardMarkup)o;
        return Objects.equals(this.keyboard, inlineKeyboardMarkup.keyboard);
    }

    public int hashCode() {
        return Objects.hash(this.keyboard);
    }

    public String toString() {
        return "InlineKeyboardMarkup{inline_keyboard=" + this.keyboard + '}';
    }
}

