/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.commands;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class BotCommand
implements BotApiObject,
Validable {
    private static final String COMMAND_FIELD = "command";
    private static final String DESCRIPTION_FIELD = "description";
    @JsonProperty(value="command")
    private String command;
    @JsonProperty(value="description")
    private String description;

    public BotCommand() {
    }

    public BotCommand(String command, String description) {
        this.command = Preconditions.checkNotNull(command);
        this.description = Preconditions.checkNotNull(description);
    }

    public String getCommand() {
        return this.command;
    }

    public BotCommand setCommand(String command) {
        this.command = command;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public BotCommand setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.command == null || this.command.isEmpty()) {
            throw new TelegramApiValidationException("Command parameter can't be empty", this);
        }
        if (this.description == null || this.description.isEmpty()) {
            throw new TelegramApiValidationException("Description parameter can't be empty", this);
        }
    }

    public String toString() {
        return "BotCommand{command='" + this.command + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

