/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetChatAdministratorCustomTitle
extends BotApiMethod<Boolean> {
    public static final String PATH = "setChatAdministratorCustomTitle";
    private static final String CHATID_FIELD = "chat_id";
    private static final String USERID_FIELD = "user_id";
    private static final String CUSTOMTITLE_FIELD = "custom_title";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="user_id")
    private Integer userId;
    @JsonProperty(value="custom_title")
    private String customTitle;

    public SetChatAdministratorCustomTitle() {
    }

    public SetChatAdministratorCustomTitle(String chatId, Integer userId, String customTitle) {
        this.chatId = Preconditions.checkNotNull(chatId);
        this.userId = Preconditions.checkNotNull(userId);
        this.customTitle = Preconditions.checkNotNull(customTitle);
    }

    public SetChatAdministratorCustomTitle(Long chatId, Integer userId, String customTitle) {
        this.chatId = Preconditions.checkNotNull(chatId).toString();
        this.userId = Preconditions.checkNotNull(userId);
        this.customTitle = Preconditions.checkNotNull(customTitle);
    }

    public String getChatId() {
        return this.chatId;
    }

    public SetChatAdministratorCustomTitle setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SetChatAdministratorCustomTitle setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public SetChatAdministratorCustomTitle setUserId(Integer userId) {
        Preconditions.checkNotNull(userId);
        this.userId = userId;
        return this;
    }

    public String getCustomTitle() {
        return this.customTitle;
    }

    public SetChatAdministratorCustomTitle setCustomTitle(String customTitle) {
        Preconditions.checkNotNull(customTitle);
        this.customTitle = customTitle;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error setting chat description", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.userId == null || this.userId == 0) {
            throw new TelegramApiValidationException("UserId can't be empty", this);
        }
        if (this.customTitle == null) {
            throw new TelegramApiValidationException("CustomTitle can't be null", this);
        }
    }

    public String toString() {
        return "SetChatDescription{chatId='" + this.chatId + '\'' + "userId='" + this.userId + '\'' + ", customTitle='" + this.customTitle + '\'' + '}';
    }
}

