/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.telegram.telegrambots.bots.DefaultAbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.facilities.TelegramHttpClientBuilder;
import org.telegram.telegrambots.meta.api.methods.updates.DeleteWebhook;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;

public final class WebhookUtils {
    private WebhookUtils() {
    }

    public static void setWebhook(DefaultAbsSender bot, String url, String publicCertificatePath) throws TelegramApiRequestException {
        DefaultBotOptions botOptions = bot.getOptions();
        try (CloseableHttpClient httpclient = TelegramHttpClientBuilder.build(botOptions);){
            File certificate;
            String requestUrl = bot.getBaseUrl() + "setwebhook";
            RequestConfig requestConfig = botOptions.getRequestConfig();
            if (requestConfig == null) {
                requestConfig = RequestConfig.copy(RequestConfig.custom().build()).setSocketTimeout(75000).setConnectTimeout(75000).setConnectionRequestTimeout(75000).build();
            }
            HttpPost httppost = new HttpPost(requestUrl);
            httppost.setConfig(requestConfig);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("url", url);
            if (botOptions.getMaxWebhookConnections() != null) {
                builder.addTextBody("max_connections", botOptions.getMaxWebhookConnections().toString());
            }
            if (botOptions.getAllowedUpdates() != null) {
                builder.addTextBody("allowed_updates", new JSONArray(botOptions.getAllowedUpdates()).toString());
            }
            if (publicCertificatePath != null && (certificate = new File(publicCertificatePath)).exists()) {
                builder.addBinaryBody("certificate", certificate, ContentType.TEXT_PLAIN, certificate.getName());
            }
            HttpEntity multipart = builder.build();
            httppost.setEntity(multipart);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost, botOptions.getHttpContext());){
                String responseContent = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
                JSONObject jsonObject = new JSONObject(responseContent);
                if (!jsonObject.getBoolean("ok")) {
                    throw new TelegramApiRequestException("Error setting webhook", jsonObject);
                }
            }
        }
        catch (JSONException e) {
            throw new TelegramApiRequestException("Error deserializing setWebhook method response", e);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Error executing setWebook method", e);
        }
    }

    public static void clearWebhook(DefaultAbsSender bot) throws TelegramApiRequestException {
        try {
            boolean result = (Boolean)bot.execute(new DeleteWebhook());
            if (!result) {
                throw new TelegramApiRequestException("Error removing old webhook");
            }
        }
        catch (TelegramApiException e) {
            throw new TelegramApiRequestException("Error removing old webhook", e);
        }
    }
}

