/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.payments.ShippingOption;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class AnswerShippingQuery
extends BotApiMethod<Boolean> {
    public static final String PATH = "answerShippingQuery";
    private static final String SHIPPING_QUERY_ID_FIELD = "shipping_query_id";
    private static final String OK_FIELD = "ok";
    private static final String SHIPPING_OPTIONS_FIELD = "shipping_options";
    private static final String ERROR_MESSAGE_FIELD = "error_message";
    @JsonProperty(value="shipping_query_id")
    private String shippingQueryId;
    @JsonProperty(value="ok")
    private Boolean ok;
    @JsonProperty(value="shipping_options")
    private List<ShippingOption> shippingOptions;
    @JsonProperty(value="error_message")
    private String errorMessage;

    public AnswerShippingQuery() {
    }

    public AnswerShippingQuery(String shippingQueryId, Boolean ok) {
        this.shippingQueryId = Preconditions.checkNotNull(shippingQueryId);
        this.ok = Preconditions.checkNotNull(ok);
    }

    public String getShippingQueryId() {
        return this.shippingQueryId;
    }

    public AnswerShippingQuery setShippingQueryId(String shippingQueryId) {
        this.shippingQueryId = Preconditions.checkNotNull(shippingQueryId);
        return this;
    }

    public Boolean getOk() {
        return this.ok;
    }

    public AnswerShippingQuery setOk(Boolean ok) {
        this.ok = Preconditions.checkNotNull(ok);
        return this;
    }

    public List<ShippingOption> getShippingOptions() {
        return this.shippingOptions;
    }

    public AnswerShippingQuery setShippingOptions(List<ShippingOption> shippingOptions) {
        this.shippingOptions = shippingOptions;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public AnswerShippingQuery setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.shippingQueryId == null || this.shippingQueryId.isEmpty()) {
            throw new TelegramApiValidationException("ShippingQueryId can't be empty", this);
        }
        if (this.ok == null) {
            throw new TelegramApiValidationException("Ok can't be null", this);
        }
        if (this.ok.booleanValue()) {
            if (this.shippingOptions == null || this.shippingOptions.isEmpty()) {
                throw new TelegramApiValidationException("ShippingOptions array can't be empty if ok", this);
            }
            for (ShippingOption shippingOption : this.shippingOptions) {
                shippingOption.validate();
            }
        } else if (this.errorMessage == null || this.errorMessage.isEmpty()) {
            throw new TelegramApiValidationException("ErrorMessage can't be empty if not ok", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error answering shipping query", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    public String toString() {
        return "AnswerShippingQuery{shippingQueryId='" + this.shippingQueryId + '\'' + ", ok=" + this.ok + ", shippingOptions=" + this.shippingOptions + ", errorMessage='" + this.errorMessage + '\'' + '}';
    }
}

