/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class LeaveChat
extends BotApiMethod<Boolean> {
    public static final String PATH = "leaveChat";
    private static final String CHATID_FIELD = "chat_id";
    @JsonProperty(value="chat_id")
    private String chatId;

    public String getChatId() {
        return this.chatId;
    }

    public LeaveChat setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public LeaveChat setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error leaving chat", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be null", this);
        }
    }

    public String toString() {
        return "LeaveChat{chatId='" + this.chatId + '\'' + '}';
    }
}

