/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.passport.dataerror;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class PassportElementErrorUnspecified
implements PassportElementError {
    private static final String SOURCE_FIELD = "source";
    private static final String TYPE_FIELD = "type";
    private static final String ELEMENTHASH_FIELD = "element_hash";
    private static final String MESSAGE_FIELD = "message";
    @JsonProperty(value="source")
    private final String source = "unspecified";
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="element_hash")
    private String elementHash;
    @JsonProperty(value="message")
    private String message;

    public PassportElementErrorUnspecified() {
    }

    public PassportElementErrorUnspecified(String type, String elementHash, String message) {
        this.type = Preconditions.checkNotNull(type);
        this.elementHash = Preconditions.checkNotNull(elementHash);
        this.message = Preconditions.checkNotNull(message);
    }

    public String getType() {
        return this.type;
    }

    public PassportElementErrorUnspecified setType(String type) {
        this.type = Preconditions.checkNotNull(type);
        return this;
    }

    public String getSource() {
        return "unspecified";
    }

    public String getElementHash() {
        return this.elementHash;
    }

    public PassportElementErrorUnspecified setElementHash(String elementHash) {
        this.elementHash = elementHash;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public PassportElementErrorUnspecified setMessage(String message) {
        this.message = Preconditions.checkNotNull(message);
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.elementHash == null || this.elementHash.isEmpty()) {
            throw new TelegramApiValidationException("Element hash parameter can't be empty", this);
        }
        if (this.message == null || this.message.isEmpty()) {
            throw new TelegramApiValidationException("Message parameter can't be empty", this);
        }
        if (this.type == null || this.type.isEmpty()) {
            throw new TelegramApiValidationException("Type parameter can't be empty", this);
        }
    }

    public String toString() {
        return "PassportElementErrorFile{source='unspecified', type='" + this.type + '\'' + ", elementHash='" + this.elementHash + '\'' + ", message='" + this.message + '\'' + '}';
    }
}

