/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.interfaces.InputBotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.KeyboardButtonPollType;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class KeyboardButton
implements InputBotApiObject,
Validable {
    private static final String TEXT_FIELD = "text";
    private static final String REQUEST_CONTACT_FIELD = "request_contact";
    private static final String REQUEST_LOCATION_FIELD = "request_location";
    private static final String REQUEST_POLL_FIELD = "request_poll";
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="request_contact")
    private Boolean requestContact;
    @JsonProperty(value="request_location")
    private Boolean requestLocation;
    @JsonProperty(value="request_poll")
    private KeyboardButtonPollType requestPoll;

    public KeyboardButton() {
    }

    public KeyboardButton(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public KeyboardButton setText(String text) {
        this.text = text;
        return this;
    }

    public Boolean getRequestContact() {
        return this.requestContact;
    }

    public KeyboardButton setRequestContact(Boolean requestContact) {
        this.requestContact = requestContact;
        return this;
    }

    public Boolean getRequestLocation() {
        return this.requestLocation;
    }

    public KeyboardButton setRequestLocation(Boolean requestLocation) {
        this.requestLocation = requestLocation;
        return this;
    }

    public KeyboardButtonPollType getRequestPoll() {
        return this.requestPoll;
    }

    public KeyboardButton setRequestPoll(KeyboardButtonPollType requestPoll) {
        this.requestPoll = requestPoll;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
        if (this.requestContact != null && this.requestLocation != null && this.requestContact.booleanValue() && this.requestLocation.booleanValue()) {
            throw new TelegramApiValidationException("Cant request contact and location at the same time", this);
        }
        if (this.requestContact != null && this.requestPoll != null && this.requestContact.booleanValue()) {
            throw new TelegramApiValidationException("Cant request contact and poll at the same time", this);
        }
        if (this.requestLocation != null && this.requestPoll != null && this.requestLocation.booleanValue()) {
            throw new TelegramApiValidationException("Cant request location and poll at the same time", this);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyboardButton)) {
            return false;
        }
        KeyboardButton keyboardButton = (KeyboardButton)o;
        return Objects.equals(this.requestContact, keyboardButton.requestContact) && Objects.equals(this.requestLocation, keyboardButton.requestLocation) && Objects.equals(this.requestPoll, keyboardButton.requestPoll) && Objects.equals(this.text, keyboardButton.text);
    }

    public int hashCode() {
        return Objects.hash(this.requestContact, this.requestLocation, this.requestPoll, this.text);
    }

    public String toString() {
        return "KeyboardButton{text=" + this.text + ", requestContact=" + this.requestContact + ", requestLocation=" + this.requestLocation + ", requestPoll=" + this.requestPoll + '}';
    }
}

