/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.stickers.StickerSet;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class GetStickerSet
extends BotApiMethod<StickerSet> {
    private static final String PATH = "getStickerSet";
    private static final String NAME_FIELD = "name";
    @JsonProperty(value="name")
    @NonNull
    private String name;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public StickerSet deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<StickerSet> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<StickerSet>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error getting sticker set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.name == null || this.name.isEmpty()) {
            throw new TelegramApiValidationException("Name can't be null", this);
        }
    }

    public static GetStickerSetBuilder builder() {
        return new GetStickerSetBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetStickerSet)) {
            return false;
        }
        GetStickerSet other = (GetStickerSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetStickerSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public String toString() {
        return "GetStickerSet(name=" + this.getName() + ")";
    }

    public GetStickerSet() {
    }

    public GetStickerSet(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public static class GetStickerSetBuilder {
        private String name;

        GetStickerSetBuilder() {
        }

        @JsonProperty(value="name")
        public GetStickerSetBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public GetStickerSet build() {
            return new GetStickerSet(this.name);
        }

        public String toString() {
            return "GetStickerSet.GetStickerSetBuilder(name=" + this.name + ")";
        }
    }
}

