/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.games;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.Serializable;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetGameScore
extends BotApiMethod<Serializable> {
    public static final String PATH = "setGameScore";
    private static final String USER_ID_FIELD = "user_id";
    private static final String SCORE_FIELD = "score";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String DISABLEEDITMESSAGE_FIELD = "disable_edit_message";
    private static final String FORCE_FIELD = "force";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="disable_edit_message")
    private Boolean disableEditMessage;
    @JsonProperty(value="user_id")
    @NonNull
    private Integer userId;
    @JsonProperty(value="score")
    @NonNull
    private Integer score;
    @JsonProperty(value="force")
    private Boolean force;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Serializable deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error setting game score", result);
        }
        catch (IOException e) {
            try {
                ApiResponse<Message> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Message>>(){});
                if (result.getOk().booleanValue()) {
                    return result.getResult();
                }
                throw new TelegramApiRequestException("Error setting game score", result);
            }
            catch (IOException e2) {
                throw new TelegramApiRequestException("Unable to deserialize response", e2);
            }
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null) {
            throw new TelegramApiValidationException("UserId parameter can't be empty", this);
        }
        if (this.score == null) {
            throw new TelegramApiValidationException("Score parameter can't be empty", this);
        }
        if (this.inlineMessageId == null) {
            if (this.chatId == null) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
    }

    public static SetGameScoreBuilder builder() {
        return new SetGameScoreBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetGameScore)) {
            return false;
        }
        SetGameScore other = (SetGameScore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Boolean this$disableEditMessage = this.getDisableEditMessage();
        Boolean other$disableEditMessage = other.getDisableEditMessage();
        if (this$disableEditMessage == null ? other$disableEditMessage != null : !((Object)this$disableEditMessage).equals(other$disableEditMessage)) {
            return false;
        }
        Integer this$userId = this.getUserId();
        Integer other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Integer this$score = this.getScore();
        Integer other$score = other.getScore();
        if (this$score == null ? other$score != null : !((Object)this$score).equals(other$score)) {
            return false;
        }
        Boolean this$force = this.getForce();
        Boolean other$force = other.getForce();
        if (this$force == null ? other$force != null : !((Object)this$force).equals(other$force)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inlineMessageId = this.getInlineMessageId();
        String other$inlineMessageId = other.getInlineMessageId();
        return !(this$inlineMessageId == null ? other$inlineMessageId != null : !this$inlineMessageId.equals(other$inlineMessageId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetGameScore;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Boolean $disableEditMessage = this.getDisableEditMessage();
        result = result * 59 + ($disableEditMessage == null ? 43 : ((Object)$disableEditMessage).hashCode());
        Integer $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Integer $score = this.getScore();
        result = result * 59 + ($score == null ? 43 : ((Object)$score).hashCode());
        Boolean $force = this.getForce();
        result = result * 59 + ($force == null ? 43 : ((Object)$force).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inlineMessageId = this.getInlineMessageId();
        result = result * 59 + ($inlineMessageId == null ? 43 : $inlineMessageId.hashCode());
        return result;
    }

    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public Boolean getDisableEditMessage() {
        return this.disableEditMessage;
    }

    @NonNull
    public Integer getUserId() {
        return this.userId;
    }

    @NonNull
    public Integer getScore() {
        return this.score;
    }

    public Boolean getForce() {
        return this.force;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="inline_message_id")
    public void setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
    }

    @JsonProperty(value="disable_edit_message")
    public void setDisableEditMessage(Boolean disableEditMessage) {
        this.disableEditMessage = disableEditMessage;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NonNull Integer userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="score")
    public void setScore(@NonNull Integer score) {
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        this.score = score;
    }

    @JsonProperty(value="force")
    public void setForce(Boolean force) {
        this.force = force;
    }

    public String toString() {
        return "SetGameScore(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ", disableEditMessage=" + this.getDisableEditMessage() + ", userId=" + this.getUserId() + ", score=" + this.getScore() + ", force=" + this.getForce() + ")";
    }

    public SetGameScore() {
    }

    public SetGameScore(@NonNull Integer userId, @NonNull Integer score) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        this.userId = userId;
        this.score = score;
    }

    public SetGameScore(String chatId, Integer messageId, String inlineMessageId, Boolean disableEditMessage, @NonNull Integer userId, @NonNull Integer score, Boolean force) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (score == null) {
            throw new NullPointerException("score is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
        this.disableEditMessage = disableEditMessage;
        this.userId = userId;
        this.score = score;
        this.force = force;
    }

    public static class SetGameScoreBuilder {
        private String chatId;
        private Integer messageId;
        private String inlineMessageId;
        private Boolean disableEditMessage;
        private Integer userId;
        private Integer score;
        private Boolean force;

        SetGameScoreBuilder() {
        }

        @JsonProperty(value="chat_id")
        public SetGameScoreBuilder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="message_id")
        public SetGameScoreBuilder messageId(Integer messageId) {
            this.messageId = messageId;
            return this;
        }

        @JsonProperty(value="inline_message_id")
        public SetGameScoreBuilder inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return this;
        }

        @JsonProperty(value="disable_edit_message")
        public SetGameScoreBuilder disableEditMessage(Boolean disableEditMessage) {
            this.disableEditMessage = disableEditMessage;
            return this;
        }

        @JsonProperty(value="user_id")
        public SetGameScoreBuilder userId(@NonNull Integer userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="score")
        public SetGameScoreBuilder score(@NonNull Integer score) {
            if (score == null) {
                throw new NullPointerException("score is marked non-null but is null");
            }
            this.score = score;
            return this;
        }

        @JsonProperty(value="force")
        public SetGameScoreBuilder force(Boolean force) {
            this.force = force;
            return this;
        }

        public SetGameScore build() {
            return new SetGameScore(this.chatId, this.messageId, this.inlineMessageId, this.disableEditMessage, this.userId, this.score, this.force);
        }

        public String toString() {
            return "SetGameScore.SetGameScoreBuilder(chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", disableEditMessage=" + this.disableEditMessage + ", userId=" + this.userId + ", score=" + this.score + ", force=" + this.force + ")";
        }
    }
}

