/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetStickerSetThumb
extends BotApiMethod<Boolean> {
    private static final String PATH = "setStickerSetThumb";
    public static final String NAME_FIELD = "name";
    public static final String USERID_FIELD = "user_id";
    public static final String THUMB_FIELD = "thumb";
    @NonNull
    private String name;
    @NonNull
    private Integer userId;
    @NonNull
    private InputFile thumb;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error setting sticker thumb in set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.name == null || this.name.isEmpty()) {
            throw new TelegramApiValidationException("name can't be null", this);
        }
        if (this.userId == null || this.userId == 0) {
            throw new TelegramApiValidationException("userId can't be null", this);
        }
        if (this.thumb == null) {
            throw new TelegramApiValidationException("thumb can't be null", this);
        }
        this.thumb.validate();
    }

    public static SetStickerSetThumbBuilder builder() {
        return new SetStickerSetThumbBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetStickerSetThumb)) {
            return false;
        }
        SetStickerSetThumb other = (SetStickerSetThumb)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$userId = this.getUserId();
        Integer other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        InputFile this$thumb = this.getThumb();
        InputFile other$thumb = other.getThumb();
        return !(this$thumb == null ? other$thumb != null : !((Object)this$thumb).equals(other$thumb));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetStickerSetThumb;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        InputFile $thumb = this.getThumb();
        result = result * 59 + ($thumb == null ? 43 : ((Object)$thumb).hashCode());
        return result;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public Integer getUserId() {
        return this.userId;
    }

    @NonNull
    public InputFile getThumb() {
        return this.thumb;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setUserId(@NonNull Integer userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    public void setThumb(@NonNull InputFile thumb) {
        if (thumb == null) {
            throw new NullPointerException("thumb is marked non-null but is null");
        }
        this.thumb = thumb;
    }

    public String toString() {
        return "SetStickerSetThumb(name=" + this.getName() + ", userId=" + this.getUserId() + ", thumb=" + this.getThumb() + ")";
    }

    public SetStickerSetThumb() {
    }

    public SetStickerSetThumb(@NonNull String name, @NonNull Integer userId, @NonNull InputFile thumb) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (thumb == null) {
            throw new NullPointerException("thumb is marked non-null but is null");
        }
        this.name = name;
        this.userId = userId;
        this.thumb = thumb;
    }

    public static class SetStickerSetThumbBuilder {
        private String name;
        private Integer userId;
        private InputFile thumb;

        SetStickerSetThumbBuilder() {
        }

        public SetStickerSetThumbBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public SetStickerSetThumbBuilder userId(@NonNull Integer userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        public SetStickerSetThumbBuilder thumb(@NonNull InputFile thumb) {
            if (thumb == null) {
                throw new NullPointerException("thumb is marked non-null but is null");
            }
            this.thumb = thumb;
            return this;
        }

        public SetStickerSetThumb build() {
            return new SetStickerSetThumb(this.name, this.userId, this.thumb);
        }

        public String toString() {
            return "SetStickerSetThumb.SetStickerSetThumbBuilder(name=" + this.name + ", userId=" + this.userId + ", thumb=" + this.thumb + ")";
        }
    }
}

