/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updatingmessages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class EditMessageText
extends BotApiMethod<Serializable> {
    public static final String PATH = "editmessagetext";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String TEXT_FIELD = "text";
    private static final String PARSE_MODE_FIELD = "parse_mode";
    private static final String DISABLE_WEB_PREVIEW_FIELD = "disable_web_page_preview";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    private static final String ENTITIES_FIELD = "entities";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="text")
    @NonNull
    private String text;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="disable_web_page_preview")
    private Boolean disableWebPagePreview;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="entities")
    private List<MessageEntity> entities;

    public void disableWebPagePreview() {
        this.disableWebPagePreview = true;
    }

    public void enableWebPagePreview() {
        this.disableWebPagePreview = null;
    }

    public void enableMarkdown(boolean enable) {
        this.parseMode = enable ? "Markdown" : null;
    }

    public void enableHtml(boolean enable) {
        this.parseMode = enable ? "html" : null;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Serializable deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Message> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error editing message text", result);
        }
        catch (IOException e) {
            try {
                ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
                if (result.getOk().booleanValue()) {
                    return result.getResult();
                }
                throw new TelegramApiRequestException("Error editing message text", result);
            }
            catch (IOException e2) {
                throw new TelegramApiRequestException("Unable to deserialize response", e);
            }
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineMessageId == null) {
            if (this.chatId == null) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
        if (this.text == null || this.text.isEmpty()) {
            throw new TelegramApiValidationException("Text parameter can't be empty", this);
        }
        if (this.parseMode != null && this.entities != null && !this.entities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static EditMessageTextBuilder builder() {
        return new EditMessageTextBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditMessageText)) {
            return false;
        }
        EditMessageText other = (EditMessageText)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Boolean this$disableWebPagePreview = this.getDisableWebPagePreview();
        Boolean other$disableWebPagePreview = other.getDisableWebPagePreview();
        if (this$disableWebPagePreview == null ? other$disableWebPagePreview != null : !((Object)this$disableWebPagePreview).equals(other$disableWebPagePreview)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inlineMessageId = this.getInlineMessageId();
        String other$inlineMessageId = other.getInlineMessageId();
        if (this$inlineMessageId == null ? other$inlineMessageId != null : !this$inlineMessageId.equals(other$inlineMessageId)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        List<MessageEntity> this$entities = this.getEntities();
        List<MessageEntity> other$entities = other.getEntities();
        return !(this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EditMessageText;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Boolean $disableWebPagePreview = this.getDisableWebPagePreview();
        result = result * 59 + ($disableWebPagePreview == null ? 43 : ((Object)$disableWebPagePreview).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inlineMessageId = this.getInlineMessageId();
        result = result * 59 + ($inlineMessageId == null ? 43 : $inlineMessageId.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        List<MessageEntity> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        return result;
    }

    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    @NonNull
    public String getText() {
        return this.text;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public Boolean getDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public List<MessageEntity> getEntities() {
        return this.entities;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="inline_message_id")
    public void setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
    }

    @JsonProperty(value="text")
    public void setText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="disable_web_page_preview")
    public void setDisableWebPagePreview(Boolean disableWebPagePreview) {
        this.disableWebPagePreview = disableWebPagePreview;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="entities")
    public void setEntities(List<MessageEntity> entities) {
        this.entities = entities;
    }

    public String toString() {
        return "EditMessageText(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ", text=" + this.getText() + ", parseMode=" + this.getParseMode() + ", disableWebPagePreview=" + this.getDisableWebPagePreview() + ", replyMarkup=" + this.getReplyMarkup() + ", entities=" + this.getEntities() + ")";
    }

    public EditMessageText(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
    }

    public EditMessageText() {
    }

    public EditMessageText(String chatId, Integer messageId, String inlineMessageId, @NonNull String text, String parseMode, Boolean disableWebPagePreview, InlineKeyboardMarkup replyMarkup, List<MessageEntity> entities) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
        this.text = text;
        this.parseMode = parseMode;
        this.disableWebPagePreview = disableWebPagePreview;
        this.replyMarkup = replyMarkup;
        this.entities = entities;
    }

    public static class EditMessageTextBuilder {
        private String chatId;
        private Integer messageId;
        private String inlineMessageId;
        private String text;
        private String parseMode;
        private Boolean disableWebPagePreview;
        private InlineKeyboardMarkup replyMarkup;
        private List<MessageEntity> entities;

        EditMessageTextBuilder() {
        }

        @JsonProperty(value="chat_id")
        public EditMessageTextBuilder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="message_id")
        public EditMessageTextBuilder messageId(Integer messageId) {
            this.messageId = messageId;
            return this;
        }

        @JsonProperty(value="inline_message_id")
        public EditMessageTextBuilder inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return this;
        }

        @JsonProperty(value="text")
        public EditMessageTextBuilder text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this;
        }

        @JsonProperty(value="parse_mode")
        public EditMessageTextBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        @JsonProperty(value="disable_web_page_preview")
        public EditMessageTextBuilder disableWebPagePreview(Boolean disableWebPagePreview) {
            this.disableWebPagePreview = disableWebPagePreview;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public EditMessageTextBuilder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="entities")
        public EditMessageTextBuilder entities(List<MessageEntity> entities) {
            this.entities = entities;
            return this;
        }

        public EditMessageText build() {
            return new EditMessageText(this.chatId, this.messageId, this.inlineMessageId, this.text, this.parseMode, this.disableWebPagePreview, this.replyMarkup, this.entities);
        }

        public String toString() {
            return "EditMessageText.EditMessageTextBuilder(chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", text=" + this.text + ", parseMode=" + this.parseMode + ", disableWebPagePreview=" + this.disableWebPagePreview + ", replyMarkup=" + this.replyMarkup + ", entities=" + this.entities + ")";
        }
    }
}

