/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.ChatInviteLink;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class EditChatInviteLink
extends BotApiMethod<ChatInviteLink> {
    public static final String PATH = "createChatInviteLink";
    private static final String CHATID_FIELD = "chat_id";
    private static final String INVITELINK_FIELD = "invite_link";
    private static final String EXPIREDATE_FIELD = "expire_date";
    private static final String MEMBERLIMIT_FIELD = "member_limit";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="invite_link")
    @NonNull
    private String inviteLink;
    @JsonProperty(value="expire_date")
    private Integer expireDate;
    @JsonProperty(value="member_limit")
    private Integer memberLimit;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ChatInviteLink deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<ChatInviteLink> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<ChatInviteLink>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error creating invite link", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (Strings.isNullOrEmpty(this.chatId)) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (Strings.isNullOrEmpty(this.inviteLink)) {
            throw new TelegramApiValidationException("InviteLink can't be empty", this);
        }
        if (this.memberLimit != null && (this.memberLimit < 1 || this.memberLimit > 99999)) {
            throw new TelegramApiValidationException("MemberLimit must be between 1 and 99999", this);
        }
    }

    public static EditChatInviteLinkBuilder builder() {
        return new EditChatInviteLinkBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditChatInviteLink)) {
            return false;
        }
        EditChatInviteLink other = (EditChatInviteLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$expireDate = this.getExpireDate();
        Integer other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !((Object)this$expireDate).equals(other$expireDate)) {
            return false;
        }
        Integer this$memberLimit = this.getMemberLimit();
        Integer other$memberLimit = other.getMemberLimit();
        if (this$memberLimit == null ? other$memberLimit != null : !((Object)this$memberLimit).equals(other$memberLimit)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inviteLink = this.getInviteLink();
        String other$inviteLink = other.getInviteLink();
        return !(this$inviteLink == null ? other$inviteLink != null : !this$inviteLink.equals(other$inviteLink));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EditChatInviteLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : ((Object)$expireDate).hashCode());
        Integer $memberLimit = this.getMemberLimit();
        result = result * 59 + ($memberLimit == null ? 43 : ((Object)$memberLimit).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inviteLink = this.getInviteLink();
        result = result * 59 + ($inviteLink == null ? 43 : $inviteLink.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public String getInviteLink() {
        return this.inviteLink;
    }

    public Integer getExpireDate() {
        return this.expireDate;
    }

    public Integer getMemberLimit() {
        return this.memberLimit;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="invite_link")
    public void setInviteLink(@NonNull String inviteLink) {
        if (inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.inviteLink = inviteLink;
    }

    @JsonProperty(value="expire_date")
    public void setExpireDate(Integer expireDate) {
        this.expireDate = expireDate;
    }

    @JsonProperty(value="member_limit")
    public void setMemberLimit(Integer memberLimit) {
        this.memberLimit = memberLimit;
    }

    public String toString() {
        return "EditChatInviteLink(chatId=" + this.getChatId() + ", inviteLink=" + this.getInviteLink() + ", expireDate=" + this.getExpireDate() + ", memberLimit=" + this.getMemberLimit() + ")";
    }

    public EditChatInviteLink() {
    }

    public EditChatInviteLink(@NonNull String chatId, @NonNull String inviteLink, Integer expireDate, Integer memberLimit) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.chatId = chatId;
        this.inviteLink = inviteLink;
        this.expireDate = expireDate;
        this.memberLimit = memberLimit;
    }

    public EditChatInviteLink(@NonNull String chatId, @NonNull String inviteLink) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.chatId = chatId;
        this.inviteLink = inviteLink;
    }

    public static class EditChatInviteLinkBuilder {
        private String chatId;
        private String inviteLink;
        private Integer expireDate;
        private Integer memberLimit;

        EditChatInviteLinkBuilder() {
        }

        @JsonProperty(value="chat_id")
        public EditChatInviteLinkBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="invite_link")
        public EditChatInviteLinkBuilder inviteLink(@NonNull String inviteLink) {
            if (inviteLink == null) {
                throw new NullPointerException("inviteLink is marked non-null but is null");
            }
            this.inviteLink = inviteLink;
            return this;
        }

        @JsonProperty(value="expire_date")
        public EditChatInviteLinkBuilder expireDate(Integer expireDate) {
            this.expireDate = expireDate;
            return this;
        }

        @JsonProperty(value="member_limit")
        public EditChatInviteLinkBuilder memberLimit(Integer memberLimit) {
            this.memberLimit = memberLimit;
            return this;
        }

        public EditChatInviteLink build() {
            return new EditChatInviteLink(this.chatId, this.inviteLink, this.expireDate, this.memberLimit);
        }

        public String toString() {
            return "EditChatInviteLink.EditChatInviteLinkBuilder(chatId=" + this.chatId + ", inviteLink=" + this.inviteLink + ", expireDate=" + this.expireDate + ", memberLimit=" + this.memberLimit + ")";
        }
    }
}

