/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class DeleteStickerFromSet
extends BotApiMethod<Boolean> {
    private static final String PATH = "deleteStickerFromSet";
    private static final String STICKER_FIELD = "sticker";
    @JsonProperty(value="sticker")
    @NonNull
    private String sticker;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error deleting sticker from set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.sticker == null || this.sticker.isEmpty()) {
            throw new TelegramApiValidationException("sticker can't be null", this);
        }
    }

    public static DeleteStickerFromSetBuilder builder() {
        return new DeleteStickerFromSetBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteStickerFromSet)) {
            return false;
        }
        DeleteStickerFromSet other = (DeleteStickerFromSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sticker = this.getSticker();
        String other$sticker = other.getSticker();
        return !(this$sticker == null ? other$sticker != null : !this$sticker.equals(other$sticker));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteStickerFromSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : $sticker.hashCode());
        return result;
    }

    @NonNull
    public String getSticker() {
        return this.sticker;
    }

    @JsonProperty(value="sticker")
    public void setSticker(@NonNull String sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    public String toString() {
        return "DeleteStickerFromSet(sticker=" + this.getSticker() + ")";
    }

    public DeleteStickerFromSet() {
    }

    public DeleteStickerFromSet(@NonNull String sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    public static class DeleteStickerFromSetBuilder {
        private String sticker;

        DeleteStickerFromSetBuilder() {
        }

        @JsonProperty(value="sticker")
        public DeleteStickerFromSetBuilder sticker(@NonNull String sticker) {
            if (sticker == null) {
                throw new NullPointerException("sticker is marked non-null but is null");
            }
            this.sticker = sticker;
            return this;
        }

        public DeleteStickerFromSet build() {
            return new DeleteStickerFromSet(this.sticker);
        }

        public String toString() {
            return "DeleteStickerFromSet.DeleteStickerFromSetBuilder(sticker=" + this.sticker + ")";
        }
    }
}

