/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updatingmessages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class EditMessageCaption
extends BotApiMethod<Serializable> {
    public static final String PATH = "editmessagecaption";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String INLINE_MESSAGE_ID_FIELD = "inline_message_id";
    private static final String CAPTION_FIELD = "caption";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="inline_message_id")
    private String inlineMessageId;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Serializable deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Message> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error editing message caption", result);
        }
        catch (IOException e) {
            try {
                ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
                if (result.getOk().booleanValue()) {
                    return result.getResult();
                }
                throw new TelegramApiRequestException("Error editing message caption", result);
            }
            catch (IOException e2) {
                throw new TelegramApiRequestException("Unable to deserialize response", e);
            }
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineMessageId == null) {
            if (this.chatId == null) {
                throw new TelegramApiValidationException("ChatId parameter can't be empty if inlineMessageId is not present", this);
            }
            if (this.messageId == null) {
                throw new TelegramApiValidationException("MessageId parameter can't be empty if inlineMessageId is not present", this);
            }
        } else {
            if (this.chatId != null) {
                throw new TelegramApiValidationException("ChatId parameter must be empty if inlineMessageId is provided", this);
            }
            if (this.messageId != null) {
                throw new TelegramApiValidationException("MessageId parameter must be empty if inlineMessageId is provided", this);
            }
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static EditMessageCaptionBuilder builder() {
        return new EditMessageCaptionBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditMessageCaption)) {
            return false;
        }
        EditMessageCaption other = (EditMessageCaption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inlineMessageId = this.getInlineMessageId();
        String other$inlineMessageId = other.getInlineMessageId();
        if (this$inlineMessageId == null ? other$inlineMessageId != null : !this$inlineMessageId.equals(other$inlineMessageId)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EditMessageCaption;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inlineMessageId = this.getInlineMessageId();
        result = result * 59 + ($inlineMessageId == null ? 43 : $inlineMessageId.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageId() {
        return this.messageId;
    }

    public String getInlineMessageId() {
        return this.inlineMessageId;
    }

    public String getCaption() {
        return this.caption;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(Integer messageId) {
        this.messageId = messageId;
    }

    @JsonProperty(value="inline_message_id")
    public void setInlineMessageId(String inlineMessageId) {
        this.inlineMessageId = inlineMessageId;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public String toString() {
        return "EditMessageCaption(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ", inlineMessageId=" + this.getInlineMessageId() + ", caption=" + this.getCaption() + ", replyMarkup=" + this.getReplyMarkup() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    public EditMessageCaption() {
    }

    public EditMessageCaption(String chatId, Integer messageId, String inlineMessageId, String caption, InlineKeyboardMarkup replyMarkup, String parseMode, List<MessageEntity> captionEntities) {
        this.chatId = chatId;
        this.messageId = messageId;
        this.inlineMessageId = inlineMessageId;
        this.caption = caption;
        this.replyMarkup = replyMarkup;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
    }

    public static class EditMessageCaptionBuilder {
        private String chatId;
        private Integer messageId;
        private String inlineMessageId;
        private String caption;
        private InlineKeyboardMarkup replyMarkup;
        private String parseMode;
        private ArrayList<MessageEntity> captionEntities;

        EditMessageCaptionBuilder() {
        }

        @JsonProperty(value="chat_id")
        public EditMessageCaptionBuilder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="message_id")
        public EditMessageCaptionBuilder messageId(Integer messageId) {
            this.messageId = messageId;
            return this;
        }

        @JsonProperty(value="inline_message_id")
        public EditMessageCaptionBuilder inlineMessageId(String inlineMessageId) {
            this.inlineMessageId = inlineMessageId;
            return this;
        }

        @JsonProperty(value="caption")
        public EditMessageCaptionBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public EditMessageCaptionBuilder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="parse_mode")
        public EditMessageCaptionBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public EditMessageCaptionBuilder captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this;
        }

        @JsonProperty(value="caption_entities")
        public EditMessageCaptionBuilder captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this;
        }

        public EditMessageCaptionBuilder clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this;
        }

        public EditMessageCaption build() {
            List<MessageEntity> captionEntities;
            switch (this.captionEntities == null ? 0 : this.captionEntities.size()) {
                case 0: {
                    captionEntities = Collections.emptyList();
                    break;
                }
                case 1: {
                    captionEntities = Collections.singletonList(this.captionEntities.get(0));
                    break;
                }
                default: {
                    captionEntities = Collections.unmodifiableList(new ArrayList<MessageEntity>(this.captionEntities));
                }
            }
            return new EditMessageCaption(this.chatId, this.messageId, this.inlineMessageId, this.caption, this.replyMarkup, this.parseMode, captionEntities);
        }

        public String toString() {
            return "EditMessageCaption.EditMessageCaptionBuilder(chatId=" + this.chatId + ", messageId=" + this.messageId + ", inlineMessageId=" + this.inlineMessageId + ", caption=" + this.caption + ", replyMarkup=" + this.replyMarkup + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ")";
        }
    }
}

