/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.stickers.MaskPosition;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class AddStickerToSet
extends PartialBotApiMethod<Boolean> {
    public static final String PATH = "addStickerToSet";
    public static final String USERID_FIELD = "user_id";
    public static final String NAME_FIELD = "name";
    public static final String PNGSTICKER_FIELD = "png_sticker";
    public static final String TGSSTICKER_FIELD = "tgs_sticker";
    public static final String EMOJIS_FIELD = "emojis";
    public static final String MASKPOSITION_FIELD = "mask_position";
    @NonNull
    private Long userId;
    @NonNull
    private String name;
    @NonNull
    private String emojis;
    private MaskPosition maskPosition;
    private InputFile pngSticker;
    private InputFile tgsSticker;

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error creating new sticker set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null || this.userId <= 0L) {
            throw new TelegramApiValidationException("userId can't be empty", this);
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new TelegramApiValidationException("name can't be empty", this);
        }
        if (this.emojis == null || this.emojis.isEmpty()) {
            throw new TelegramApiValidationException("emojis can't be empty", this);
        }
        if (this.pngSticker == null && this.tgsSticker == null) {
            throw new TelegramApiValidationException("One of pngSticker or tgsSticker is needed", this);
        }
        if (this.pngSticker != null && this.tgsSticker != null) {
            throw new TelegramApiValidationException("Only one of pngSticker or tgsSticker are allowed", this);
        }
        if (this.pngSticker != null) {
            this.pngSticker.validate();
        }
        if (this.tgsSticker != null) {
            this.tgsSticker.validate();
        }
        if (this.maskPosition != null) {
            this.maskPosition.validate();
        }
    }

    public static AddStickerToSetBuilder builder() {
        return new AddStickerToSetBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddStickerToSet)) {
            return false;
        }
        AddStickerToSet other = (AddStickerToSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$emojis = this.getEmojis();
        String other$emojis = other.getEmojis();
        if (this$emojis == null ? other$emojis != null : !this$emojis.equals(other$emojis)) {
            return false;
        }
        MaskPosition this$maskPosition = this.getMaskPosition();
        MaskPosition other$maskPosition = other.getMaskPosition();
        if (this$maskPosition == null ? other$maskPosition != null : !((Object)this$maskPosition).equals(other$maskPosition)) {
            return false;
        }
        InputFile this$pngSticker = this.getPngSticker();
        InputFile other$pngSticker = other.getPngSticker();
        if (this$pngSticker == null ? other$pngSticker != null : !((Object)this$pngSticker).equals(other$pngSticker)) {
            return false;
        }
        InputFile this$tgsSticker = this.getTgsSticker();
        InputFile other$tgsSticker = other.getTgsSticker();
        return !(this$tgsSticker == null ? other$tgsSticker != null : !((Object)this$tgsSticker).equals(other$tgsSticker));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddStickerToSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $emojis = this.getEmojis();
        result = result * 59 + ($emojis == null ? 43 : $emojis.hashCode());
        MaskPosition $maskPosition = this.getMaskPosition();
        result = result * 59 + ($maskPosition == null ? 43 : ((Object)$maskPosition).hashCode());
        InputFile $pngSticker = this.getPngSticker();
        result = result * 59 + ($pngSticker == null ? 43 : ((Object)$pngSticker).hashCode());
        InputFile $tgsSticker = this.getTgsSticker();
        result = result * 59 + ($tgsSticker == null ? 43 : ((Object)$tgsSticker).hashCode());
        return result;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getEmojis() {
        return this.emojis;
    }

    public MaskPosition getMaskPosition() {
        return this.maskPosition;
    }

    public InputFile getPngSticker() {
        return this.pngSticker;
    }

    public InputFile getTgsSticker() {
        return this.tgsSticker;
    }

    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setEmojis(@NonNull String emojis) {
        if (emojis == null) {
            throw new NullPointerException("emojis is marked non-null but is null");
        }
        this.emojis = emojis;
    }

    public void setMaskPosition(MaskPosition maskPosition) {
        this.maskPosition = maskPosition;
    }

    public void setPngSticker(InputFile pngSticker) {
        this.pngSticker = pngSticker;
    }

    public void setTgsSticker(InputFile tgsSticker) {
        this.tgsSticker = tgsSticker;
    }

    public String toString() {
        return "AddStickerToSet(userId=" + this.getUserId() + ", name=" + this.getName() + ", emojis=" + this.getEmojis() + ", maskPosition=" + this.getMaskPosition() + ", pngSticker=" + this.getPngSticker() + ", tgsSticker=" + this.getTgsSticker() + ")";
    }

    public AddStickerToSet(@NonNull Long userId, @NonNull String name, @NonNull String emojis) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (emojis == null) {
            throw new NullPointerException("emojis is marked non-null but is null");
        }
        this.userId = userId;
        this.name = name;
        this.emojis = emojis;
    }

    public AddStickerToSet() {
    }

    public AddStickerToSet(@NonNull Long userId, @NonNull String name, @NonNull String emojis, MaskPosition maskPosition, InputFile pngSticker, InputFile tgsSticker) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (emojis == null) {
            throw new NullPointerException("emojis is marked non-null but is null");
        }
        this.userId = userId;
        this.name = name;
        this.emojis = emojis;
        this.maskPosition = maskPosition;
        this.pngSticker = pngSticker;
        this.tgsSticker = tgsSticker;
    }

    public static class AddStickerToSetBuilder {
        private Long userId;
        private String name;
        private String emojis;
        private MaskPosition maskPosition;
        private InputFile pngSticker;
        private InputFile tgsSticker;

        AddStickerToSetBuilder() {
        }

        public AddStickerToSetBuilder userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        public AddStickerToSetBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public AddStickerToSetBuilder emojis(@NonNull String emojis) {
            if (emojis == null) {
                throw new NullPointerException("emojis is marked non-null but is null");
            }
            this.emojis = emojis;
            return this;
        }

        public AddStickerToSetBuilder maskPosition(MaskPosition maskPosition) {
            this.maskPosition = maskPosition;
            return this;
        }

        public AddStickerToSetBuilder pngSticker(InputFile pngSticker) {
            this.pngSticker = pngSticker;
            return this;
        }

        public AddStickerToSetBuilder tgsSticker(InputFile tgsSticker) {
            this.tgsSticker = tgsSticker;
            return this;
        }

        public AddStickerToSet build() {
            return new AddStickerToSet(this.userId, this.name, this.emojis, this.maskPosition, this.pngSticker, this.tgsSticker);
        }

        public String toString() {
            return "AddStickerToSet.AddStickerToSetBuilder(userId=" + this.userId + ", name=" + this.name + ", emojis=" + this.emojis + ", maskPosition=" + this.maskPosition + ", pngSticker=" + this.pngSticker + ", tgsSticker=" + this.tgsSticker + ")";
        }
    }
}

