/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.commands;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.commands.BotCommand;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetMyCommands
extends BotApiMethod<Boolean> {
    public static final String PATH = "setMyCommands";
    private static final String COMMANDS_FIELD = "commands";
    @JsonProperty(value="commands")
    @NonNull
    private List<BotCommand> commands;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error sending commands", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.commands == null) {
            throw new TelegramApiValidationException("Commands parameter can't be empty", this);
        }
        if (this.commands.size() > 100) {
            throw new TelegramApiValidationException("No more than 100 commands are allowed", this);
        }
        for (BotCommand command : this.commands) {
            command.validate();
        }
    }

    public static SetMyCommandsBuilder builder() {
        return new SetMyCommandsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetMyCommands)) {
            return false;
        }
        SetMyCommands other = (SetMyCommands)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<BotCommand> this$commands = this.getCommands();
        List<BotCommand> other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetMyCommands;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BotCommand> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    @NonNull
    public List<BotCommand> getCommands() {
        return this.commands;
    }

    @JsonProperty(value="commands")
    public void setCommands(@NonNull List<BotCommand> commands) {
        if (commands == null) {
            throw new NullPointerException("commands is marked non-null but is null");
        }
        this.commands = commands;
    }

    public String toString() {
        return "SetMyCommands(commands=" + this.getCommands() + ")";
    }

    public SetMyCommands() {
    }

    public SetMyCommands(@NonNull List<BotCommand> commands) {
        if (commands == null) {
            throw new NullPointerException("commands is marked non-null but is null");
        }
        this.commands = commands;
    }

    public static class SetMyCommandsBuilder {
        private ArrayList<BotCommand> commands;

        SetMyCommandsBuilder() {
        }

        public SetMyCommandsBuilder command(BotCommand command) {
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.add(command);
            return this;
        }

        @JsonProperty(value="commands")
        public SetMyCommandsBuilder commands(Collection<? extends BotCommand> commands) {
            if (commands == null) {
                throw new NullPointerException("commands cannot be null");
            }
            if (this.commands == null) {
                this.commands = new ArrayList();
            }
            this.commands.addAll(commands);
            return this;
        }

        public SetMyCommandsBuilder clearCommands() {
            if (this.commands != null) {
                this.commands.clear();
            }
            return this;
        }

        public SetMyCommands build() {
            List<BotCommand> commands;
            switch (this.commands == null ? 0 : this.commands.size()) {
                case 0: {
                    commands = Collections.emptyList();
                    break;
                }
                case 1: {
                    commands = Collections.singletonList(this.commands.get(0));
                    break;
                }
                default: {
                    commands = Collections.unmodifiableList(new ArrayList<BotCommand>(this.commands));
                }
            }
            return new SetMyCommands(commands);
        }

        public String toString() {
            return "SetMyCommands.SetMyCommandsBuilder(commands=" + this.commands + ")";
        }
    }
}

