/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.facilities.filedownloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClients;
import org.telegram.telegrambots.facilities.filedownloader.DownloadFileException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.updateshandlers.DownloadFileCallback;

public class TelegramFileDownloader {
    private final HttpClient httpClient;
    private final Supplier<String> botTokenSupplier;

    public TelegramFileDownloader(Supplier<String> botTokenSupplier) {
        this.botTokenSupplier = botTokenSupplier;
        this.httpClient = HttpClients.createDefault();
    }

    public TelegramFileDownloader(HttpClient httpClient, Supplier<String> botTokenSupplier) {
        this.httpClient = httpClient;
        this.botTokenSupplier = botTokenSupplier;
    }

    public final File downloadFile(String filePath) throws TelegramApiException {
        String tempFileName = Long.toString(System.currentTimeMillis());
        return this.downloadFile(filePath, this.getTempFile(tempFileName));
    }

    public final File downloadFile(org.telegram.telegrambots.meta.api.objects.File file) throws TelegramApiException {
        return this.downloadFile(file, this.getTempFile(file.getFileId()));
    }

    public final File downloadFile(org.telegram.telegrambots.meta.api.objects.File file, File outputFile) throws TelegramApiException {
        if (file == null) {
            throw new TelegramApiException("Parameter file can not be null");
        }
        String url = file.getFileUrl(this.botTokenSupplier.get());
        return this.downloadToFile(url, outputFile);
    }

    public final File downloadFile(String filePath, File outputFile) throws TelegramApiException {
        if (filePath == null || filePath.isEmpty()) {
            throw new TelegramApiException("Parameter file can not be null");
        }
        String url = org.telegram.telegrambots.meta.api.objects.File.getFileUrl(this.botTokenSupplier.get(), filePath);
        return this.downloadToFile(url, outputFile);
    }

    public final InputStream downloadFileAsStream(String filePath) throws TelegramApiException {
        try {
            return this.getFileDownloadStreamFuture(org.telegram.telegrambots.meta.api.objects.File.getFileUrl(this.botTokenSupplier.get(), filePath)).get();
        }
        catch (InterruptedException e) {
            throw new TelegramApiException("Error downloading file", e);
        }
        catch (ExecutionException e) {
            throw new TelegramApiException("Error downloading file", e.getCause());
        }
    }

    public final InputStream downloadFileAsStream(org.telegram.telegrambots.meta.api.objects.File file) throws TelegramApiException {
        try {
            return this.getFileDownloadStreamFuture(file.getFileUrl(this.botTokenSupplier.get())).get();
        }
        catch (InterruptedException e) {
            throw new TelegramApiException("Error downloading file", e);
        }
        catch (ExecutionException e) {
            throw new TelegramApiException("Error downloading file", e.getCause());
        }
    }

    public final void downloadFileAsync(String filePath, DownloadFileCallback<String> callback) throws TelegramApiException {
        if (filePath == null || filePath.isEmpty()) {
            throw new TelegramApiException("Parameter filePath can not be null");
        }
        if (callback == null) {
            throw new TelegramApiException("Parameter callback can not be null");
        }
        String url = org.telegram.telegrambots.meta.api.objects.File.getFileUrl(this.botTokenSupplier.get(), filePath);
        String tempFileName = Long.toString(System.currentTimeMillis());
        ((CompletableFuture)this.getFileDownloadFuture(url, this.getTempFile(tempFileName)).thenAccept(output -> callback.onResult(filePath, (File)output))).exceptionally(throwable -> {
            if (throwable instanceof CompletionException) {
                callback.onException(filePath, new TelegramApiException("Error downloading file", throwable.getCause()));
            } else {
                callback.onException(filePath, new TelegramApiException("Error downloading file", (Throwable)throwable));
            }
            return null;
        });
    }

    public final void downloadFileAsync(org.telegram.telegrambots.meta.api.objects.File file, DownloadFileCallback<org.telegram.telegrambots.meta.api.objects.File> callback) throws TelegramApiException {
        if (file == null) {
            throw new TelegramApiException("Parameter file can not be null");
        }
        if (callback == null) {
            throw new TelegramApiException("Parameter callback can not be null");
        }
        String url = file.getFileUrl(this.botTokenSupplier.get());
        String tempFileName = file.getFileId();
        ((CompletableFuture)this.getFileDownloadFuture(url, this.getTempFile(tempFileName)).thenAccept(output -> callback.onResult(file, (File)output))).exceptionally(throwable -> {
            callback.onException(file, new TelegramApiException("Error downloading file", (Throwable)throwable));
            return null;
        });
    }

    private File getTempFile(String tempFileName) throws TelegramApiException {
        try {
            return File.createTempFile(tempFileName, ".tmp");
        }
        catch (IOException e) {
            throw new TelegramApiException("Error downloading file", e);
        }
    }

    private File downloadToFile(String url, File output) throws TelegramApiException {
        try {
            return this.getFileDownloadFuture(url, output).get();
        }
        catch (InterruptedException e) {
            throw new TelegramApiException("File Download got interrupted", e);
        }
        catch (ExecutionException e) {
            throw new TelegramApiException("Error downloading file", e.getCause());
        }
    }

    private CompletableFuture<File> getFileDownloadFuture(String url, File output) {
        return this.getFileDownloadStreamFuture(url).thenApply(stream -> {
            try {
                FileUtils.copyInputStreamToFile(stream, output);
                return output;
            }
            catch (IOException e) {
                throw new DownloadFileException("Error writing downloaded file", e);
            }
        });
    }

    private CompletableFuture<InputStream> getFileDownloadStreamFuture(String url) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HttpResponse response = this.httpClient.execute(new HttpGet(url));
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    return response.getEntity().getContent();
                }
                throw new TelegramApiException("Unexpected Status code while downloading file. Expected 200 got " + statusCode);
            }
            catch (IOException | TelegramApiException e) {
                throw new DownloadFileException("Error downloading file", e);
            }
        });
    }
}

