/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.payments.ShippingOption;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class AnswerShippingQuery
extends BotApiMethod<Boolean> {
    public static final String PATH = "answerShippingQuery";
    private static final String SHIPPING_QUERY_ID_FIELD = "shipping_query_id";
    private static final String OK_FIELD = "ok";
    private static final String SHIPPING_OPTIONS_FIELD = "shipping_options";
    private static final String ERROR_MESSAGE_FIELD = "error_message";
    @JsonProperty(value="shipping_query_id")
    @NonNull
    private String shippingQueryId;
    @JsonProperty(value="ok")
    @NonNull
    private Boolean ok;
    @JsonProperty(value="shipping_options")
    private List<ShippingOption> shippingOptions;
    @JsonProperty(value="error_message")
    private String errorMessage;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.shippingQueryId == null || this.shippingQueryId.isEmpty()) {
            throw new TelegramApiValidationException("ShippingQueryId can't be empty", this);
        }
        if (this.ok == null) {
            throw new TelegramApiValidationException("Ok can't be null", this);
        }
        if (this.ok.booleanValue()) {
            if (this.shippingOptions == null || this.shippingOptions.isEmpty()) {
                throw new TelegramApiValidationException("ShippingOptions array can't be empty if ok", this);
            }
            for (ShippingOption shippingOption : this.shippingOptions) {
                shippingOption.validate();
            }
        } else if (this.errorMessage == null || this.errorMessage.isEmpty()) {
            throw new TelegramApiValidationException("ErrorMessage can't be empty if not ok", this);
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<Boolean> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error answering shipping query", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    public static AnswerShippingQueryBuilder builder() {
        return new AnswerShippingQueryBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerShippingQuery)) {
            return false;
        }
        AnswerShippingQuery other = (AnswerShippingQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$ok = this.getOk();
        Boolean other$ok = other.getOk();
        if (this$ok == null ? other$ok != null : !((Object)this$ok).equals(other$ok)) {
            return false;
        }
        String this$shippingQueryId = this.getShippingQueryId();
        String other$shippingQueryId = other.getShippingQueryId();
        if (this$shippingQueryId == null ? other$shippingQueryId != null : !this$shippingQueryId.equals(other$shippingQueryId)) {
            return false;
        }
        List<ShippingOption> this$shippingOptions = this.getShippingOptions();
        List<ShippingOption> other$shippingOptions = other.getShippingOptions();
        if (this$shippingOptions == null ? other$shippingOptions != null : !((Object)this$shippingOptions).equals(other$shippingOptions)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnswerShippingQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ok = this.getOk();
        result = result * 59 + ($ok == null ? 43 : ((Object)$ok).hashCode());
        String $shippingQueryId = this.getShippingQueryId();
        result = result * 59 + ($shippingQueryId == null ? 43 : $shippingQueryId.hashCode());
        List<ShippingOption> $shippingOptions = this.getShippingOptions();
        result = result * 59 + ($shippingOptions == null ? 43 : ((Object)$shippingOptions).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    @NonNull
    public String getShippingQueryId() {
        return this.shippingQueryId;
    }

    @NonNull
    public Boolean getOk() {
        return this.ok;
    }

    public List<ShippingOption> getShippingOptions() {
        return this.shippingOptions;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="shipping_query_id")
    public void setShippingQueryId(@NonNull String shippingQueryId) {
        if (shippingQueryId == null) {
            throw new NullPointerException("shippingQueryId is marked non-null but is null");
        }
        this.shippingQueryId = shippingQueryId;
    }

    @JsonProperty(value="ok")
    public void setOk(@NonNull Boolean ok) {
        if (ok == null) {
            throw new NullPointerException("ok is marked non-null but is null");
        }
        this.ok = ok;
    }

    @JsonProperty(value="shipping_options")
    public void setShippingOptions(List<ShippingOption> shippingOptions) {
        this.shippingOptions = shippingOptions;
    }

    @JsonProperty(value="error_message")
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String toString() {
        return "AnswerShippingQuery(shippingQueryId=" + this.getShippingQueryId() + ", ok=" + this.getOk() + ", shippingOptions=" + this.getShippingOptions() + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    public AnswerShippingQuery() {
    }

    public AnswerShippingQuery(@NonNull String shippingQueryId, @NonNull Boolean ok) {
        if (shippingQueryId == null) {
            throw new NullPointerException("shippingQueryId is marked non-null but is null");
        }
        if (ok == null) {
            throw new NullPointerException("ok is marked non-null but is null");
        }
        this.shippingQueryId = shippingQueryId;
        this.ok = ok;
    }

    public AnswerShippingQuery(@NonNull String shippingQueryId, @NonNull Boolean ok, List<ShippingOption> shippingOptions, String errorMessage) {
        if (shippingQueryId == null) {
            throw new NullPointerException("shippingQueryId is marked non-null but is null");
        }
        if (ok == null) {
            throw new NullPointerException("ok is marked non-null but is null");
        }
        this.shippingQueryId = shippingQueryId;
        this.ok = ok;
        this.shippingOptions = shippingOptions;
        this.errorMessage = errorMessage;
    }

    public static class AnswerShippingQueryBuilder {
        private String shippingQueryId;
        private Boolean ok;
        private List<ShippingOption> shippingOptions;
        private String errorMessage;

        AnswerShippingQueryBuilder() {
        }

        @JsonProperty(value="shipping_query_id")
        public AnswerShippingQueryBuilder shippingQueryId(@NonNull String shippingQueryId) {
            if (shippingQueryId == null) {
                throw new NullPointerException("shippingQueryId is marked non-null but is null");
            }
            this.shippingQueryId = shippingQueryId;
            return this;
        }

        @JsonProperty(value="ok")
        public AnswerShippingQueryBuilder ok(@NonNull Boolean ok) {
            if (ok == null) {
                throw new NullPointerException("ok is marked non-null but is null");
            }
            this.ok = ok;
            return this;
        }

        @JsonProperty(value="shipping_options")
        public AnswerShippingQueryBuilder shippingOptions(List<ShippingOption> shippingOptions) {
            this.shippingOptions = shippingOptions;
            return this;
        }

        @JsonProperty(value="error_message")
        public AnswerShippingQueryBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public AnswerShippingQuery build() {
            return new AnswerShippingQuery(this.shippingQueryId, this.ok, this.shippingOptions, this.errorMessage);
        }

        public String toString() {
            return "AnswerShippingQuery.AnswerShippingQueryBuilder(shippingQueryId=" + this.shippingQueryId + ", ok=" + this.ok + ", shippingOptions=" + this.shippingOptions + ", errorMessage=" + this.errorMessage + ")";
        }
    }
}

