/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.updates;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class GetUpdates
extends BotApiMethod<ArrayList<Update>> {
    public static final String PATH = "getupdates";
    private static final String OFFSET_FIELD = "offset";
    private static final String LIMIT_FIELD = "limit";
    private static final String TIMEOUT_FIELD = "timeout";
    private static final String ALLOWEDUPDATES_FIELD = "allowed_updates";
    @JsonProperty(value="offset")
    private Integer offset;
    @JsonProperty(value="limit")
    private Integer limit;
    @JsonProperty(value="timeout")
    private Integer timeout;
    @JsonProperty(value="allowed_updates")
    private List<String> allowedUpdates;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ArrayList<Update> deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse<ArrayList<Update>> result = OBJECT_MAPPER.readValue(answer, new TypeReference<ApiResponse<ArrayList<Update>>>(){});
            if (result.getOk().booleanValue()) {
                return result.getResult();
            }
            throw new TelegramApiRequestException("Error getting updates", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
    }

    public static GetUpdatesBuilder builder() {
        return new GetUpdatesBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetUpdates)) {
            return false;
        }
        GetUpdates other = (GetUpdates)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        List<String> this$allowedUpdates = this.getAllowedUpdates();
        List<String> other$allowedUpdates = other.getAllowedUpdates();
        return !(this$allowedUpdates == null ? other$allowedUpdates != null : !((Object)this$allowedUpdates).equals(other$allowedUpdates));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetUpdates;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        List<String> $allowedUpdates = this.getAllowedUpdates();
        result = result * 59 + ($allowedUpdates == null ? 43 : ((Object)$allowedUpdates).hashCode());
        return result;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public List<String> getAllowedUpdates() {
        return this.allowedUpdates;
    }

    @JsonProperty(value="offset")
    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    @JsonProperty(value="limit")
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @JsonProperty(value="timeout")
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    @JsonProperty(value="allowed_updates")
    public void setAllowedUpdates(List<String> allowedUpdates) {
        this.allowedUpdates = allowedUpdates;
    }

    public String toString() {
        return "GetUpdates(offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", timeout=" + this.getTimeout() + ", allowedUpdates=" + this.getAllowedUpdates() + ")";
    }

    public GetUpdates() {
    }

    public GetUpdates(Integer offset, Integer limit, Integer timeout, List<String> allowedUpdates) {
        this.offset = offset;
        this.limit = limit;
        this.timeout = timeout;
        this.allowedUpdates = allowedUpdates;
    }

    public static class GetUpdatesBuilder {
        private Integer offset;
        private Integer limit;
        private Integer timeout;
        private ArrayList<String> allowedUpdates;

        GetUpdatesBuilder() {
        }

        @JsonProperty(value="offset")
        public GetUpdatesBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        @JsonProperty(value="limit")
        public GetUpdatesBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @JsonProperty(value="timeout")
        public GetUpdatesBuilder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public GetUpdatesBuilder allowedUpdate(String allowedUpdate) {
            if (this.allowedUpdates == null) {
                this.allowedUpdates = new ArrayList();
            }
            this.allowedUpdates.add(allowedUpdate);
            return this;
        }

        @JsonProperty(value="allowed_updates")
        public GetUpdatesBuilder allowedUpdates(Collection<? extends String> allowedUpdates) {
            if (allowedUpdates == null) {
                throw new NullPointerException("allowedUpdates cannot be null");
            }
            if (this.allowedUpdates == null) {
                this.allowedUpdates = new ArrayList();
            }
            this.allowedUpdates.addAll(allowedUpdates);
            return this;
        }

        public GetUpdatesBuilder clearAllowedUpdates() {
            if (this.allowedUpdates != null) {
                this.allowedUpdates.clear();
            }
            return this;
        }

        public GetUpdates build() {
            List<String> allowedUpdates;
            switch (this.allowedUpdates == null ? 0 : this.allowedUpdates.size()) {
                case 0: {
                    allowedUpdates = Collections.emptyList();
                    break;
                }
                case 1: {
                    allowedUpdates = Collections.singletonList(this.allowedUpdates.get(0));
                    break;
                }
                default: {
                    allowedUpdates = Collections.unmodifiableList(new ArrayList<String>(this.allowedUpdates));
                }
            }
            return new GetUpdates(this.offset, this.limit, this.timeout, allowedUpdates);
        }

        public String toString() {
            return "GetUpdates.GetUpdatesBuilder(offset=" + this.offset + ", limit=" + this.limit + ", timeout=" + this.timeout + ", allowedUpdates=" + this.allowedUpdates + ")";
        }
    }
}

